% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSPMind.R
\name{PSPMind}
\alias{PSPMind}
\title{Computes the individual life history of a physiologically structured population model in a given environment}
\usage{
PSPMind(
  modelname = NULL,
  environment = NULL,
  parameters = NULL,
  options = NULL,
  clean = FALSE,
  force = FALSE,
  debug = FALSE,
  silent = FALSE
)
}
\arguments{
\item{modelname}{(string, required)
\preformatted{}
              Basename of the file with the model specification. The file
              should have an extension ".h". For example, the model "PNAS2002"
              is specified in the file "PNAS2002.h". If the model is specified 
              in R include the .R extension explicitly, i.e. specify the model
              name as "PNAS2002.R"}

\item{environment}{(row vector, required)
\preformatted{}
                Vector of length ENVIRON_DIM (set in the model program
                file; This is the length of the variable 'EnvironmentState' if the
                model is specified in R), specifying the value of the environmental variables
                at which to calculate the individual life history.
                This vector can also be extended with values of the birth rates for all structured
                populations in the model, which would scale the output of the model with these
                birth rates.}

\item{parameters}{(row vector, optional, can be left equal to its default NULL)
\preformatted{}
              Vector of length PARAMETER_NR (set in the model program
              file; This is the length of the variable 'DefaultParameters' if the
              model is specified in R), specifying the values for the model
              parameters to use in the computation. Vectors of other lengths,
              including an empty vector will be ignored.}

\item{options}{(row vector of strings, optional, can be left equal to its default NULL)
\preformatted{}
                Vector with a pair of strings, consisting of an option name and a value (for
                example c("isort", "1")). The only possible option name and its values is:
\preformatted{}

                \verb{"isort", "<index>"}: Index of i-state variable to use as
                                     ruling variable for sorting the
                                     structured populations}

\item{clean}{(Boolean, optional argument)
\preformatted{}
                Specify clean = TRUE as argument to remove all the result files
                of the model before the computation}

\item{force}{(Boolean, optional argument)
\preformatted{}
                Specify force = TRUE as argument to force a rebuilding of the model
                before the computation}

\item{debug}{(Boolean, optional argument)
Specify debug = TRUE as argument to compile the model in verbose
mode and with debugging flag set}

\item{silent}{(Boolean, optional argument)
\preformatted{}
              Specify silent = TRUE as argument to suppress reporting of compilation
              commands and results on the console}
}
\value{
The output is a structure with the population state as normally stored in the
  .csb output file of \code{\link{PSPMdemo}}, \code{\link{PSPMequi}}, \code{\link{PSPMecodyn}} and
\code{\link{PSPMevodyn}}.
}
\description{
\code{PSPMind} is a utility function to compute the individual life history as
defined by a physiologically structured population model, given a specific
set of values for the environmental variables
}
\details{
output <- PSPMind(modelname = NULL, environment = NULL, parameters = NULL, options = NULL,
                    clean = FALSE, force = FALSE, debug = FALSE, silent = FALSE)
}
\examples{
\dontrun{
PSPMind("PNAS2002_5bs", c(1.30341E-05, 3.84655E-05, 4.00802E-06), 
        options = c("isort", "1"), clean=TRUE, force=TRUE)
}

}
