% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{wait_for_writable}
\alias{wait_for_writable}
\title{Check if a file is writable and blocks an interactive session, waiting for user input.}
\usage{
wait_for_writable(filename, prompt_text = paste0("The file '", filename,
  "' is not writable. Please close all applications using this file. Press '",
  abort_answer, "' to abort!"), abort_answer = "n")
}
\arguments{
\item{filename}{The file to test for writable}

\item{prompt_text}{If not writable, show this prompt text to the user}

\item{abort_answer}{If the user enters this string into the prompt, this function will stop()}
}
\value{
TRUE if writable, FALSE if aborted by user or (not-writeable and non-interactive)
}
\description{
This functions gives the user a chance to make the output file writeable before a write attempt
is actually made by R to avoid having run the whole program again upon write failure.
}
\details{
Note: The file will not be overwritten or changed by this function.
}

