% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_misc.R
\name{hasFileSuffix}
\alias{hasFileSuffix}
\title{Checks if filepath ends in suffix. If suffix does not start with a '.' it is prepended automatically.}
\usage{
hasFileSuffix(filepath, suffix)
}
\arguments{
\item{filepath}{A relative or absolute path to a file, whose suffix is checked}

\item{suffix}{This is the suffix we expect (the '.' is prepended internally if missing)}
}
\value{
TRUE if yes, FALSE otherwise
}
\description{
Checks if filepath ends in suffix. If suffix does not start with a '.' it is prepended automatically.
}
\examples{
  hasFileSuffix("bla.txt", "txt")    # TRUE
  hasFileSuffix("bla.txt", ".txt")   # TRUE
  hasFileSuffix("bla.txt", "doc")    # FALSE
  hasFileSuffix("bla.txt", ".doc")   # FALSE
  hasFileSuffix("fo", ".doc")        # FALSE
  hasFileSuffix("", ".doc")          # FALSE
  hasFileSuffix("foo", "")           # FALSE

}
