% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_peptideMods.R
\name{plot_peptideMods}
\alias{plot_peptideMods}
\title{Plot peptide modification frequencies}
\usage{
plot_peptideMods(tbl, y_max = NA, show_missing_modification_levels = TRUE)
}
\arguments{
\item{tbl}{A data.frame with 'fc.raw.file', 'modification_names' (can be a factor), and 'Freq' (0-100)}

\item{y_max}{The upper limit of the y-axis's (==Freq); useful for multiple plots with identical limits; if 'NA' the limit is computed from the given 'tbl'}

\item{show_missing_modification_levels}{If 'tbl$modification_names' is a factor and has more (but missing) levels than actually used, should missing values be dropped or assumed as '0' frequency?}
}
\value{
GGplot object
}
\description{
The input is a data.frame, as obtained from modsToTableByRaw().
}
\examples{

 data = data.frame(fc.raw.file = rep(c("file A", "file B"), each=3),
                   modifications = c("Oxidation (M)",
                   "Unmodified",
                   "Oxidation (M), Acetyl (Protein N-term)",
                   "2 Oxidation (M)", 
                   "Unmodified", 
                   "Unmodified"))
 tbl = modsToTableByRaw(data)
 plot_peptideMods(tbl,show_missing_modification_levels = TRUE)

}
