% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skill_ROC.R
\name{skill_ROC}
\alias{skill_ROC}
\title{ROC Curve}
\usage{
skill_ROC(predicted, observed, t1Range = NULL, t2 = NULL, n = 101)
}
\arguments{
\item{predicted}{vector of predicted values (or a \emph{ws_monitor} object with a single location)}

\item{observed}{vector of observed values (or a \emph{ws_monitor} object with a single location)}

\item{t1Range}{lo and high values used to generate test thresholds for classifying \code{predicted} data}

\item{t2}{used to classify \code{observed} data}

\item{n}{number of test thresholds in ROC curve}
}
\value{
List containing an \code{roc} matrix and the \code{auc} area under the ROC curve.
}
\description{
This function calculates an ROC dataframe of TPR, FPR, and Cost for a range of
thresholds as well as the area under the ROC curve.
}
\examples{
\dontrun{
# Fail gracefully if any resources are not available
try({

# Napa Fires -- October, 2017
ca <- airnow_loadAnnual(2017) \%>\%
  monitor_subset(tlim = c(20171001,20171101), stateCodes = 'CA')
Vallejo <- monitor_subset(ca, monitorIDs = '060950004_01')
Napa <- monitor_subset(ca, monitorIDs = '060550003_01')
t2 <- AQI$breaks_24[4] # 'Unhealthy'
rocList <- skill_ROC(Vallejo, Napa, t1Range = c(0,100), t2 = t2)
roc <- rocList$roc
auc <- rocList$auc
plot(roc$TPR ~ roc$FPR, type = 'S')
title(paste0('Area Under Curve = ', format(auc,digits = 3)))

}, silent = FALSE)
}
}
\references{
\href{https://en.wikipedia.org/wiki/Receiver_operating_characteristic}{Receiver Operating Characteristic}
}
\seealso{
\link{skill_confusionMatrix}

\link{skill_ROCPlot}
}
