% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPgDate.R
\name{convertPgDate}
\alias{convertPgDate}
\title{Convert Pamguard Numeric Date to POSIXct}
\usage{
convertPgDate(dateNum)
}
\arguments{
\item{dateNum}{date as a numeric, seconds since 1970-01-01 per standard
Pamguard output. Timezone is UTC}
}
\value{
A POSIXct date in UTC
}
\description{
a simple helper to convert Pamguard's numeric date to
  POSIXct format
}
\examples{

# load the example click binary data, leaving date as numeric
clickFile <- system.file('extdata', 'Click.pgdf', package='PamBinaries')
clickData <- loadPamguardBinaryFile(clickFile, convertDate = FALSE)
# convert date to POSIXct
convertPgDate(clickData$data[[1]]$date)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
