% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIterations.R
\name{addIterations}
\alias{addIterations}
\title{Run Additional Optimization Iterations}
\usage{
addIterations(
  optObj,
  iters.n = 1,
  iters.k = 1,
  bounds = optObj$bounds,
  kern = optObj$optPars$kern,
  acq = optObj$optPars$acq,
  kappa = optObj$optPars$kappa,
  eps = optObj$optPars$eps,
  gsPoints = optObj$optPars$gsPoints,
  convThresh = optObj$optPars$convThresh,
  acqThresh = optObj$optPars$acqThresh,
  saveFile = optObj$saveFile,
  parallel = FALSE,
  plotProgress = TRUE,
  verbose = 1
)
}
\arguments{
\item{optObj}{an object of class \code{bayesOpt}.}

\item{iters.n}{The total number of additional times to sample the scoring function.}

\item{iters.k}{integer that specifies the number of times to sample FUN
at each Epoch (optimization step). If running in parallel, good practice
is to set \code{iters.k} to some multiple of the number of cores you have designated
for this process. Must belower than, and preferrably some multiple of \code{iters.n}.}

\item{bounds}{Same as bayesOpt()}

\item{kern}{Same as bayesOpt()}

\item{acq}{Same as bayesOpt()}

\item{kappa}{Same as bayesOpt()}

\item{eps}{Same as bayesOpt()}

\item{gsPoints}{Same as bayesOpt()}

\item{convThresh}{Same as bayesOpt()}

\item{acqThresh}{Same as bayesOpt()}

\item{saveFile}{Same as bayesOpt()}

\item{parallel}{Same as bayesOpt()}

\item{plotProgress}{Same as bayesOpt()}

\item{verbose}{Same as bayesOpt()}
}
\value{
A \code{bayesOpt} object.
}
\description{
Use this function to continue optimization of a bayesOpt object.
}
\details{
By default, this function uses the original parameters used to create
\code{optObj}, however the parameters (including the bounds) can be customized.
If new bounds are used which cause some of the prior runs to fall outside of
the bounds, these samples are removed from the optimization procedure, but
will remain in \code{scoreSummary}. \code{FUN} should return the same elements
and accept the same inputs as the original, or this function may fail.
}
