% Generated by roxygen2 (4.0.1): do not edit by hand
\name{trafoValue}
\alias{trafoValue}
\title{Transform a value.}
\usage{
trafoValue(par, x)
}
\arguments{
\item{par}{[\code{\link{Param}} | \code{\link{ParamSet}}]\cr
Parameter or parameter set.}

\item{x}{[any] \cr
Single value to check.
For a parameter set this must be a list in the correct order.}
}
\value{
Transformed value.
}
\description{
Transform a value with associated transformation function(s).
}
\examples{
# transform simple parameter:
p = makeNumericParam(id="x", trafo=function(x) x^2)
trafoValue(p, 2)
# for a parameter set different transformation functions are possible:
ps = makeParamSet(
  makeIntegerParam("u", trafo=function(x) 2*x),
  makeNumericVectorParam("v", len=2, trafo=function(x) x/sum(x)),
  makeDiscreteParam("w", values=c("a", "b"))
)
# now the values of "u" and "v" are transformed:
trafoValue(ps, list(3, c(2, 4), "a"))
}

