% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{qGenPareto}
\alias{qGenPareto}
\title{Quantile Function of the generalized Pareto Distribution}
\usage{
qGenPareto(p, t, alpha_ini, alpha_tail, truncation = NULL)
}
\arguments{
\item{p}{Numeric. The function evaluates the inverse CDF at \code{p}.}

\item{t}{Numeric. Threshold of the piecewise Pareto distribution.}

\item{alpha_ini}{Numeric. Initial Pareto alpha.}

\item{alpha_tail}{Numeric. Tail Pareto alpha.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} and \code{truncation > t}, then the generalized Pareto distribution is truncated at \code{truncation}.}
}
\value{
Quantile function of the Pareto distribution with parameters \code{t}, \code{alpha_ini} and \code{alpha_tail}, evaluated at \code{p}
}
\description{
Calculates the quantile function of a generalized Pareto distribution
}
\examples{
p <- 0:10 * 0.1
qGenPareto(p, 1000, 2, 3)
qGenPareto(p, 1000, 2, 3, truncation = 5000)

}
