% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Modigliani}
\alias{Modigliani}
\title{Modigliani-Modigliani measure}
\usage{
Modigliani(Ra, Rb, Rf = 0, ...)
}
\arguments{
\item{Ra}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{Rb}{return vector of the benchmark asset}

\item{Rf}{risk free rate, in same period as your returns}

\item{\dots}{any other passthrough parameters}
}
\description{
The Modigliani-Modigliani measure is the portfolio return adjusted upward
or downward to match the benchmark's standard deviation. This puts the
portfolio return and the benchmark return on 'equal footing' from a standard
deviation perspective.
\deqn{MM_{p}=\frac{E[R_{p} - R_{f}]}{\sigma_{p}}=SR_{p} * \sigma_{b} +
E[R_{f}]}{MMp = SRp * sigmab + E[Rf]}
where \eqn{SR_{p}}{SRp} - Sharpe ratio, \eqn{\sigma_{b}}{sigmab} - benchmark
standard deviation
}
\details{
This is also analogous to some approaches to 'risk parity' portfolios, which
use (presumably costless) leverage to increase the portfolio standard
deviation to some target.
}
\examples{
data(managers)
Modigliani(managers[,1,drop=FALSE], managers[,8,drop=FALSE], Rf=.035/12)
Modigliani(managers[,1:6], managers[,8,drop=FALSE], managers[,8,drop=FALSE])
Modigliani(managers[,1:6], managers[,8:7], managers[,8,drop=FALSE])
}
\author{
Andrii Babii, Brian G. Peterson
}
\references{
J. Christopherson, D. Carino, W. Ferson. \emph{Portfolio
Performance Measurement and Benchmarking}. 2009. McGraw-Hill, p. 97-99. \cr
Franco Modigliani and Leah Modigliani, "Risk-Adjusted Performance: How to
Measure It and Why," \emph{Journal of Portfolio Management}, vol.23, no.,
Winter 1997, pp.45-54 \cr
}
\seealso{
\code{\link{SharpeRatio}}, \code{\link{TreynorRatio}}
}

