% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_docs.R
\name{shelter.getPets}
\alias{shelter.getPets}
\title{Returns a collection of pet records for an individual shelter.}
\usage{
shelter.getPets(shelterId, status = NULL, offset = NULL, count = NULL,
  output = NULL, pages = NULL, return_df = FALSE)
}
\arguments{
\item{shelterId}{Desired shelter's ID}

\item{status}{Filters returned collection of pet records by the pet's status.
Must be one of 'A' (adoptable, default), 'H' (hold), 'P' (pending), 'X'
(adopted/removed).}

\item{offset}{Can be set to the value of lastOffset returned from the
previous call to retrieve the next set of results. The pages parameter can
also be used to pull a desired number of paged results.}

\item{count}{The number of records to return. Default is 25.}

\item{output}{Sets the amount of information returned in each record. 'basic'
returns a simple record while 'full' returns a complete record with
description. Defaults to 'basic'.}

\item{pages}{The number of pages of results to return. For example, if 
pages=4 with the default count parameter (25), 125 results would be 
returned (25 results from first call and 100 from the next four pages).}

\item{return_df}{If TRUE, the function will coerce the output JSON from the
Petfinder API into a data.frame}
}
\value{
data.frame of pet records associated with specified shelterId.
}
\description{
Returns a collection of pet records for an individual shelter.
}
\examples{
\dontrun{
pf <- Petfinder(key) # Initialize Petfinder class
pf$shelter.getPets('WA40') # Seattle Area Feline Rescue.
}
}
