% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/probeGeneMapping.R
\name{probeGeneMapping}
\alias{probeGeneMapping}
\title{Identify the best probes to use for each RNA gene, and reduce the data to
gene level}
\usage{
probeGeneMapping(pSet)
}
\arguments{
\item{pSet}{[PharmacoSet] The PharmacoSet on which to preform the mapping platform}
}
\description{
This function allows the summarization of RNA microarray data by the probe
most suitable for each gene. This function uses either the jetset package
to select the best probe to keep for each ENTREZ gene id, and
returns the dataset at a gene level. The different platforms are identified
using their GEO id.
}
\examples{
data(CGPsmall)
CGPsmall <- probeGeneMapping(CGPsmall)
}
\references{
Li Q, Birkbak NJ, Gyorffy B, Szallasi Z and Eklund AC (2011). "Jetset:
 selecting the optimal microarray probe set to represent a gene." BMC
 Bioinformatics, 12, pp. 474.
}

