% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadSignatures.R
\name{downloadPertSig}
\alias{downloadPertSig}
\title{Download Drug Perturbation Signatures}
\usage{
downloadPertSig(name, saveDir = file.path(".", "PSets", "Sigs"),
  myfn = NULL, verbose = TRUE)
}
\arguments{
\item{name}{\code{Character} string, the name of the PharmacoSet for which to
download signatures. The name should match the names returned in the
availablePSets table.}

\item{saveDir}{\code{Character} string with the folder path where the 
PharmacoSet should be saved. Defaults to \code{"./PSets/Sigs/"}. Will
create directory if it does not exist.}

\item{myfn}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status messages be printed during download.
Defaults to TRUE.}
}
\value{
An array type object contaning the signatures
}
\description{
This function allows you to download an array of drug perturbation
signatures, as would be computed by the \code{drugPerturbationSig} function,
for the available perturbation \code{PharmacoSets}. This function allows the
user to skip these very lengthy calculation steps for the datasets available,
and start their analysis from the already computed signatures
}

