% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatthewCor.R
\name{mcc}
\alias{mcc}
\title{Compute a Mathews Correlation Coefficient}
\usage{
mcc(x, y, nperm = 1000, setseed = 12345, nthread = 1)
}
\arguments{
\item{x, y}{factor of the same length with the same number of levels}

\item{nperm}{number of permutations for significance estimation. If 0, no permutation testing is done}

\item{setseed}{seed for permutation testing}

\item{nthread}{can parallelize permutation texting using parallel's mclapply}
}
\value{
A list with the MCC as the $estimate, and p value as $p.value
}
\description{
The function computes a Matthews correlation coefficient for two factors provided to the function. It assumes each factor is a factor of class labels, 
and the enteries are paired in order of the vectors.
}
\examples{
x <- factor(c(1,2,1,2,3,1))
y <- factor(c(2,1,1,1,2,2))
mcc(x,y)

}

