# Generated by OmopViewer 0.1.0
# Be careful editing this file

server <- function(input, output, session) {
  # download raw data -----
  output$download_raw <- shiny::downloadHandler(
    filename = "results.csv",
    content = function(file) {
      omopgenerics::exportSummarisedResult(data, fileName = file)
    }
  )
  # fill selectise variables ----
  shiny::observe({
    for (k in seq_along(choices)) {
      shiny::updateSelectizeInput(
        session,
        inputId = names(choices)[k],
        choices = choices[[k]],
        selected = selected[[k]],
        server = TRUE
      )
      
      shinyWidgets::updatePickerInput(session,
                                      inputId = names(choices)[k],
                                      choices = choices[[k]],
                                      selected = selected[[k]])
    }
  })
  # summarise_omop_snapshot -----
  ## output summarise_omop_snapshot -----
  ## output 17 -----
  createOutput17 <- shiny::reactive({
    if (is.null(dataFiltered$summarise_omop_snapshot)) {
      validate("No snapshot in results")
    }
    
    OmopSketch::tableOmopSnapshot(
      dataFiltered$summarise_omop_snapshot
    ) %>%
      tab_header(
        title = "Database metadata",
        subtitle = "Overview of data source"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$summarise_omop_snapshot_gt_17 <- gt::render_gt({
    createOutput17()
  })
  output$summarise_omop_snapshot_gt_17_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_omop_snapshot.", input$summarise_omop_snapshot_gt_17_download_type),
    content = function(file) {
      obj <- createOutput17()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  
  # achilles_code_use -----
  
  createOutputAchillesCodeUse <- shiny::reactive({
    if (is.null(dataFiltered$achilles_code_use)) {
      validate("No achilles code use in results")
    }
    achillesFiltered <- dataFiltered$achilles_code_use  |>
      filterData("achilles_code_use", input)
    
    if (nrow(achillesFiltered) == 0) {
      validate("No results found for selected inputs")
    }
    
    CodelistGenerator::tableAchillesCodeUse(achillesFiltered,
                                            header = input$achilles_code_use_header,
                                            groupColumn = input$achilles_code_use_groupColumn,
                                            hide = input$achilles_code_use_hide)
    
  })
  
  output$achilles_code_use_gt <- gt::render_gt({
    createOutputAchillesCodeUse()
  })
  # summarise_observation_period -----
  ## tidy summarise_observation_period -----
  getTidyDataSummariseObservationPeriod <- shiny::reactive({
    res <- dataFiltered$summarise_observation_period |>
      filterData("summarise_observation_period", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$summarise_observation_period_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$summarise_observation_period_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$summarise_observation_period_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseObservationPeriod(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$summarise_observation_period_tidy_download <- shiny::downloadHandler(
    filename = "tidy_summarise_observation_period.csv",
    content = function(file) {
      getTidyDataSummariseObservationPeriod() |>
        readr::write_csv(file = file)
    }
  )
  ## output summarise_observation_period -----
  ## output 15 -----
  createOutput15 <- shiny::reactive({
    if (is.null(dataFiltered$summarise_observation_period)) {
      validate("No observation period summary in results")
    }
    OmopSketch::tableObservationPeriod(
      dataFiltered$summarise_observation_period
    )%>%
      tab_header(
        title = "Summary of observation periods",
        subtitle = "Observation periods are used to define time under observation for individuals in the data source."
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$summarise_observation_period_gt_15 <- gt::render_gt({
    createOutput15()
  })
  output$summarise_observation_period_gt_15_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_observation_period.", input$summarise_observation_period_gt_15_download_type),
    content = function(file) {
      obj <- createOutput15()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output 16 -----
  createOutput16 <- shiny::reactive({
    result <- dataFiltered$summarise_observation_period |>
      filterData("summarise_observation_period", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    OmopSketch::plotObservationPeriod(
      result,
      variableName = input$summarise_observation_period_ggplot2_16_variableName,
      plotType = input$summarise_observation_period_ggplot2_16_plotType,
      facet = input$summarise_observation_period_ggplot2_16_facet
    )
  })
  output$summarise_observation_period_ggplot2_16 <- shiny::renderPlot({
    createOutput16()
  })
  output$summarise_observation_period_ggplot2_16_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_summarise_observation_period.", "png"),
    content = function(file) {
      obj <- createOutput16()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$summarise_observation_period_ggplot2_16_download_width),
        height = as.numeric(input$summarise_observation_period_ggplot2_16_download_height),
        units = input$summarise_observation_period_ggplot2_16_download_units,
        dpi = as.numeric(input$summarise_observation_period_ggplot2_16_download_dpi)
      )
    }
  )
  
  
  # cohort_code_use -----
  ## tidy cohort_code_use -----
  getTidyDataCohortCodeUse <- shiny::reactive({
    res <- dataFiltered$cohort_code_use |>
      tidyData()
    
    
    # pivot
    pivot <- input$cohort_code_use_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res
  })
  output$cohort_code_use_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataCohortCodeUse(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$cohort_code_use_tidy_download <- shiny::downloadHandler(
    filename = "tidy_cohort_code_use.csv",
    content = function(file) {
      getTidyDataCohortCodeUse() |>
        readr::write_csv(file = file)
    }
  )
  ## output cohort_code_use -----
  ## output 12 -----
  createOutput12 <- shiny::reactive({
    if (is.null(dataFiltered$cohort_code_use)) {
      validate("No cohort code use in results")
    }
    result <- dataFiltered$cohort_code_use |>
      filterData("cohort_code_use", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    CodelistGenerator::tableCohortCodeUse(
      result,
      header = input$cohort_code_use_gt_12_header,
      groupColumn = input$cohort_code_use_gt_12_groupColumn,
      hide = input$cohort_code_use_gt_12_hide
    )%>%
      tab_header(
        title = "Summary of cohort code use",
        subtitle = "Codes from codelist observed on day of cohort entry. Note more than one code could be seen for a person on this day (both of which would have led to inclusion)."
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$cohort_code_use_gt_12 <- gt::render_gt({
    createOutput12()
  })
  output$cohort_code_use_gt_12_download <- shiny::downloadHandler(
    filename = paste0("output_gt_cohort_code_use.", input$cohort_code_use_gt_12_download_type),
    content = function(file) {
      obj <- createOutput12()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  
  # summarise_cohort_attrition -----
  ## tidy summarise_cohort_attrition -----
  getTidyDataSummariseCohortAttrition <- shiny::reactive({
    res <- dataFiltered$summarise_cohort_attrition |>
      filterData("summarise_cohort_attrition", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$summarise_cohort_attrition_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$summarise_cohort_attrition_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$summarise_cohort_attrition_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseCohortAttrition(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$summarise_cohort_attrition_tidy_download <- shiny::downloadHandler(
    filename = "tidy_summarise_cohort_attrition.csv",
    content = function(file) {
      getTidyDataSummariseCohortAttrition() |>
        readr::write_csv(file = file)
    }
  )
  ## output summarise_cohort_attrition -----
  ## output 3 -----
  createOutput3 <- shiny::reactive({
    result <- dataFiltered$summarise_cohort_attrition |>
      filterData("summarise_cohort_attrition", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    CohortCharacteristics::tableCohortAttrition(
      result,
      header = input$summarise_cohort_attrition_gt_3_header,
      groupColumn = input$summarise_cohort_attrition_gt_3_groupColumn,
      hide = input$summarise_cohort_attrition_gt_3_hide
    )%>%
      tab_header(
        title = "Cohort attrition",
        subtitle = "Attrition into study cohorts."
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$summarise_cohort_attrition_gt_3 <- gt::render_gt({
    createOutput3()
  })
  output$summarise_cohort_attrition_gt_3_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_cohort_attrition.", input$summarise_cohort_attrition_gt_3_download_type),
    content = function(file) {
      obj <- createOutput3()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output 4 -----
  createOutput4 <- shiny::reactive({
    result <- dataFiltered$summarise_cohort_attrition |>
      filterData("summarise_cohort_attrition", input)
    CohortCharacteristics::plotCohortAttrition(
      result
    )
  })
  output$summarise_cohort_attrition_grViz_4 <- DiagrammeR::renderGrViz({
    createOutput4()
  })
  output$summarise_cohort_attrition_grViz_4_download <- shiny::downloadHandler(
    filename = paste0("output_grViz_summarise_cohort_attrition.", "png"),
    content = function(file) {
      obj <- createOutput4()
      DiagrammeR::export_graph(
        graph = obj,
        file_name = file,
        fily_type = "png",
        width = as.numeric(input$summarise_cohort_attrition_grViz_4_download_width),
        height = as.numeric(input$summarise_cohort_attrition_grViz_4_download_height)
      )
    }
  )
  
  
  # summarise_cohort_overlap -----
  ## tidy summarise_cohort_overlap -----
  getTidyDataSummariseCohortOverlap <- shiny::reactive({
    res <- dataFiltered$summarise_cohort_overlap |>
      filterData("summarise_cohort_overlap", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$summarise_cohort_overlap_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$summarise_cohort_overlap_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$summarise_cohort_overlap_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseCohortOverlap(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$summarise_cohort_overlap_tidy_download <- shiny::downloadHandler(
    filename = "tidy_summarise_cohort_overlap.csv",
    content = function(file) {
      getTidyDataSummariseCohortOverlap() |>
        readr::write_csv(file = file)
    }
  )
  ## output summarise_cohort_overlap -----
  ## output 1 -----
  createOutput1 <- shiny::reactive({
    if (is.null(dataFiltered$summarise_cohort_overlap)) {
      validate("No cohort overlap in results")
    }
    
    result <- dataFiltered$summarise_cohort_overlap |>
      filterData("summarise_cohort_overlap", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    CohortCharacteristics::tableCohortOverlap(
      result,
      uniqueCombinations = input$summarise_cohort_overlap_gt_1_uniqueCombinations,
      header = input$summarise_cohort_overlap_gt_1_header,
      groupColumn = input$summarise_cohort_overlap_gt_1_groupColumn,
      hide = input$summarise_cohort_overlap_gt_1_hide
    )%>%
      tab_header(
        title = "Cohort overlap",
        subtitle = "Overlap is where the same individual is in both cohorts. Note their cohort entries do not necessarily overlap."
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$summarise_cohort_overlap_gt_1 <- gt::render_gt({
    createOutput1()
  })
  output$summarise_cohort_overlap_gt_1_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_cohort_overlap.", input$summarise_cohort_overlap_gt_1_download_type),
    content = function(file) {
      obj <- createOutput1()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output 2 -----
  createOutput2 <- shiny::reactive({
    if (is.null(dataFiltered$summarise_cohort_overlap)) {
      validate("No cohort overlap in results")
    }
    
    result <- dataFiltered$summarise_cohort_overlap |>
      filterData("summarise_cohort_overlap", input)
    CohortCharacteristics::plotCohortOverlap(
      result,
      facet = input$summarise_cohort_overlap_ggplot2_2_facet,
      uniqueCombinations = input$summarise_cohort_overlap_ggplot2_2_uniqueCombinations
    )
  })
  output$summarise_cohort_overlap_ggplot2_2 <- plotly::renderPlotly({
    createOutput2()
  })
  output$summarise_cohort_overlap_ggplot2_2_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_summarise_cohort_overlap.", "png"),
    content = function(file) {
      obj <- createOutput2()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_width),
        height = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_height),
        units = input$summarise_cohort_overlap_ggplot2_2_download_units,
        dpi = as.numeric(input$summarise_cohort_overlap_ggplot2_2_download_dpi)
      )
    }
  )
  
  
  # summarise_characteristics -----
  ## tidy summarise_characteristics -----
  getTidyDataSummariseCharacteristics <- shiny::reactive({
    res <- dataFiltered$summarise_characteristics |>
      filterData("summarise_characteristics", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$summarise_characteristics_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$summarise_characteristics_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$summarise_characteristics_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseCharacteristics(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$summarise_characteristics_tidy_download <- shiny::downloadHandler(
    filename = "tidy_summarise_characteristics.csv",
    content = function(file) {
      getTidyDataSummariseCharacteristics() |>
        readr::write_csv(file = file)
    }
  )
  ## output summarise_characteristics -----
  ## output 7 -----
  createOutput7 <- shiny::reactive({
    
    if (is.null(dataFiltered$summarise_characteristics)) {
      validate("No summarised characteristics in results")
    }
    
    if(isTRUE(input$summarise_characteristics_include_matched)){
      selectedCohorts <- c(
        input$summarise_characteristics_grouping_cohort_name,
        paste0("matched_to_", input$summarise_characteristics_grouping_cohort_name),
        paste0(input$summarise_characteristics_grouping_cohort_name, "_sampled"),
        paste0(input$summarise_characteristics_grouping_cohort_name, "_matched")
      )
    } else {
      selectedCohorts <- input$summarise_characteristics_grouping_cohort_name
    }
    
    result <- dataFiltered$summarise_characteristics |>
      dplyr::filter(cdm_name %in% input$summarise_characteristics_grouping_cdm_name,
                    group_level %in% selectedCohorts)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    CohortCharacteristics::tableCharacteristics(
      result,
      header = input$summarise_characteristics_gt_7_header,
      groupColumn = input$summarise_characteristics_gt_7_groupColumn,
      hide = c(input$summarise_characteristics_gt_7_hide,
               "table_name", "value", "window", "table")
    ) %>%
      tab_header(
        title = "Patient characteristics",
        subtitle = "Summary of patient characteristics relative to cohort entry"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$summarise_characteristics_gt_7 <- gt::render_gt({
    createOutput7()
  })
  output$summarise_characteristics_gt_7_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_characteristics.", input$summarise_characteristics_gt_7_download_type),
    content = function(file) {
      obj <- createOutput7()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output 8 -----
  createOutput8 <- shiny::reactive({
    result <- dataFiltered$summarise_characteristics |>
      filterData("summarise_characteristics", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    CohortCharacteristics::plotCharacteristics(
      result,
      plotType = input$summarise_characteristics_ggplot2_8_plotType,
      facet = input$summarise_characteristics_ggplot2_8_facet,
      colour = input$summarise_characteristics_ggplot2_8_colour
    )
  })
  output$summarise_characteristics_ggplot2_8 <- shiny::renderPlot({
    createOutput8()
  })
  output$summarise_characteristics_ggplot2_8_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_summarise_characteristics.", "png"),
    content = function(file) {
      obj <- createOutput8()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$summarise_characteristics_ggplot2_8_download_width),
        height = as.numeric(input$summarise_characteristics_ggplot2_8_download_height),
        units = input$summarise_characteristics_ggplot2_8_download_units,
        dpi = as.numeric(input$summarise_characteristics_ggplot2_8_download_dpi)
      )
    }
  )
  
  
  # summarise_large_scale_characteristics -----
  ## tidy summarise_large_scale_characteristics -----
  getTidyDataSummariseLargeScaleCharacteristics <- shiny::reactive({

    if (is.null(dataFiltered$summarise_large_scale_characteristics)) {
      validate("No large scale characteristics in results")
    }
    
    lsc_data <- dataFiltered$summarise_large_scale_characteristics |>
      filter(!is.na(estimate_value)) |>
      filter(estimate_value != "-") |>
      visOmopResults::filterSettings(table_name %in% input$summarise_large_scale_characteristics_grouping_domain,
                                     analysis %in% input$summarise_large_scale_characteristics_settings_analysis) |>
      dplyr::filter(cdm_name %in% input$summarise_large_scale_characteristics_grouping_cdm_name ) |>
      dplyr::filter(group_level  %in% input$summarise_large_scale_characteristics_grouping_cohort_name) |>
      dplyr::filter(variable_level  %in% input$summarise_large_scale_characteristics_grouping_time_window)
    
    if (nrow(lsc_data) == 0) {
      validate("No results found for selected inputs")
    }
    
    tidy(lsc_data) |>
      mutate(concept = paste0(variable_name, " (",
                              concept_id, ")")) |>
      dplyr::select("cdm_name",
                    "concept",
                    "count",
                    "percentage")
    
  })
  output$summarise_large_scale_characteristics_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseLargeScaleCharacteristics() |>
        dplyr::arrange(dplyr::desc(percentage)),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$summarise_large_scale_characteristics_tidy_download <- shiny::downloadHandler(
    filename = "tidy_summarise_large_scale_characteristics.csv",
    content = function(file) {
      getTidyDataSummariseLargeScaleCharacteristics() |>
        readr::write_csv(file = file)
    }
  )
  ## output summarise_large_scale_characteristics -----
  ## output 0 -----
  createOutput0 <- shiny::reactive({
    
    if (is.null(dataFiltered$summarise_large_scale_characteristics)) {
      validate("No large scale characteristics in results")
    }
    
    # if (input$top_n < 1) {
    #   validate("Top n must be between 1 and 100")
    # }
    # if (input$top_n > 100) {
    #   validate("Top n must be between 1 and 100")
    # }
    
    lsc_data <- dataFiltered$summarise_large_scale_characteristics |>
      filter(!is.na(estimate_value)) |>
      filter(estimate_value != "-") |>
      visOmopResults::filterSettings(table_name %in% input$summarise_large_scale_characteristics_grouping_domain,
                                     analysis %in% input$summarise_large_scale_characteristics_settings_analysis) |>
      dplyr::filter(cdm_name %in% input$summarise_large_scale_characteristics_grouping_cdm_name ) |>
      dplyr::filter(group_level  %in% input$summarise_large_scale_characteristics_grouping_cohort_name) |>
      dplyr::filter(variable_level  %in% input$summarise_large_scale_characteristics_grouping_time_window)
    CohortCharacteristics::tableLargeScaleCharacteristics(lsc_data |>
                                                            arrange(desc(estimate_type),
                                                                    desc(as.numeric(estimate_value)))
                                                          # ,
                                                          # topConcepts = input$top_n
                                                          # ,
                                                          # header = input$summarise_large_scale_characteristics_gt_0_header,
                                                          # groupColumn = input$summarise_large_scale_characteristics_gt_0_group,
                                                          # hide = input$summarise_large_scale_characteristics_gt_0_hide
    ) %>%
      tab_header(
        title = "Large scale characteristics",
        subtitle = "Summary of all records from clinical tables within a time window"
      ) %>%
      tab_options(
        heading.align = "left"
      )
    
  })
  output$summarise_large_scale_characteristics_gt_0 <- gt::render_gt({
    createOutput0()
  })
  output$summarise_large_scale_characteristics_gt_0_download <- shiny::downloadHandler(
    filename = paste0("output_gt_summarise_large_scale_characteristics.", input$summarise_large_scale_characteristics_gt_0_download_type),
    content = function(file) {
      obj <- createOutput0()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  
  # incidence -----
  ## tidy incidence -----
  getTidyDataIncidence <- shiny::reactive({
    res <- dataFiltered$incidence |>
      filterData("incidence", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$incidence_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$incidence_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$incidence_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataIncidence(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$incidence_tidy_download <- shiny::downloadHandler(
    filename = "tidy_incidence.csv",
    content = function(file) {
      getTidyDataIncidence() |>
        readr::write_csv(file = file)
    }
  )
  ## output incidence -----
  incidenceFiltered <- shiny::reactive({
    dataFiltered$incidence |>
      filter(cdm_name %in%
               input$incidence_grouping_cdm_name) |>
      filterGroup(outcome_cohort_name %in%
                    input$incidence_grouping_outcome_cohort_name) |>
      filterSettings(denominator_age_group %in%
                       input$incidence_settings_denominator_age_group,
                     denominator_sex %in%
                       input$incidence_settings_denominator_sex) |>
      filterAdditional(analysis_interval %in%
                         input$incidence_settings_analysis_interval)
  })
  
  ## output 18 -----
  createOutput18 <- shiny::reactive({
    
    if (is.null(dataFiltered$incidence)) {
      validate("No incidence in results")
    }
    
    result <- incidenceFiltered()
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    IncidencePrevalence::tableIncidence(
      result,
      # header = input$incidence_gt_18_header,
      groupColumn = c("cdm_name", "outcome_cohort_name"),
      hide = "denominator_cohort_name",
      settingsColumns = c("denominator_age_group",
                          "denominator_sex",
                          "outcome_cohort_name")
    ) %>%
      tab_header(
        title = "Incidence estimates",
        subtitle = "Incidence rates estimated for outcomes of interest"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$incidence_gt_18 <- gt::render_gt({
    createOutput18()
  })
  output$incidence_gt_18_download <- shiny::downloadHandler(
    filename = paste0("output_gt_incidence.", input$incidence_gt_18_download_type),
    content = function(file) {
      obj <- createOutput18()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output 19 -----
  createOutput19 <- shiny::reactive({
    if (is.null(dataFiltered$incidence)) {
      validate("No incidence in results")
    }
    
    result <- incidenceFiltered()
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    IncidencePrevalence::plotIncidence(
      result,
      x = input$incidence_ggplot2_19_x,
      ribbon = FALSE,
      facet = input$incidence_ggplot2_19_facet,
      colour = input$incidence_ggplot2_19_colour
    ) |>
      plotly::ggplotly()
  })
  
  output$incidence_ggplot2_19 <- plotly::renderPlotly({
    createOutput19()
  })
  output$incidence_ggplot2_19_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_incidence.", "png"),
    content = function(file) {
      obj <- createOutput19()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$incidence_ggplot2_19_download_width),
        height = as.numeric(input$incidence_ggplot2_19_download_height),
        units = input$incidence_ggplot2_19_download_units,
        dpi = as.numeric(input$incidence_ggplot2_19_download_dpi)
      )
    }
  )
  
  
  # incidence_attrition -----
  ## tidy incidence_attrition -----
  getTidyDataIncidenceAttrition <- shiny::reactive({
    res <- dataFiltered$incidence |>
      filterData("incidence_attrition", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$incidence_attrition_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$incidence_attrition_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$incidence_attrition_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataIncidenceAttrition(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$incidence_attrition_tidy_download <- shiny::downloadHandler(
    filename = "tidy_incidence_attrition.csv",
    content = function(file) {
      getTidyDataIncidenceAttrition() |>
        readr::write_csv(file = file)
    }
  )
  ## output incidence_attrition -----
  ## output 22 -----
  createOutput22 <- shiny::reactive({
    
    if (is.null(dataFiltered$incidence_attrition)) {
      validate("No incidence attrition in results")
    }
    
    result <- dataFiltered$incidence_attrition |>
      filterData("incidence_attrition", input)
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    IncidencePrevalence::tableIncidenceAttrition(
      result,
      header = input$incidence_attrition_gt_22_header,
      groupColumn = input$incidence_attrition_gt_22_groupColumn,
      hide = input$incidence_attrition_gt_22_hide
    )%>%
      tab_header(
        title = "Incidence attrition",
        subtitle = "Subtitle"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$incidence_attrition_gt_22 <- gt::render_gt({
    createOutput22()
  })
  output$incidence_attrition_gt_22_download <- shiny::downloadHandler(
    filename = paste0("output_gt_incidence_attrition.", input$incidence_attrition_gt_22_download_type),
    content = function(file) {
      obj <- createOutput22()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  # prevalence -----
  prevalenceFiltered <- shiny::reactive({
    dataFiltered$prevalence |>
      filter(cdm_name %in%
               input$prevalence_grouping_cdm_name) |>
      filterGroup(outcome_cohort_name %in%
                    input$prevalence_grouping_outcome_cohort_name) |>
      filterSettings(denominator_age_group %in%
                       input$prevalence_settings_denominator_age_group,
                     denominator_sex %in%
                       input$prevalence_settings_denominator_sex,
                     analysis_interval %in%
                       input$prevalence_settings_analysis_interval)
  })
  
  ## tidy prevalence -----
  getTidyDataPrevalence <- shiny::reactive({
    res <- dataFiltered$prevalence |>
      filterData("prevalence", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$prevalence_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$prevalence_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$prevalence_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataPrevalence(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$prevalence_tidy_download <- shiny::downloadHandler(
    filename = "tidy_prevalence.csv",
    content = function(file) {
      getTidyDataPrevalence() |>
        readr::write_csv(file = file)
    }
  )
  ## output prevalence -----
  ## output prev1 -----
  createOutputprev1 <- shiny::reactive({
    if (is.null(dataFiltered$prevalence)) {
      validate("No prevalence in results")
    }
    
    result <- prevalenceFiltered()
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    IncidencePrevalence::tablePrevalence(
      result,
      # header = input$prevalence_gt_prev1_header,
      groupColumn = c("cdm_name", "outcome_cohort_name"),
      hide = "denominator_cohort_name",
      settingsColumns = c("denominator_age_group",
                          "denominator_sex",
                          "outcome_cohort_name")
    ) %>%
      tab_header(
        title = "Prevalence estimates",
        subtitle = "Prevalence rates estimated for outcomes of interest"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$prevalence_gt_prev1 <- gt::render_gt({
    createOutputprev1()
  })
  output$prevalence_gt_prev1_download <- shiny::downloadHandler(
    filename = paste0("output_gt_prevalence.", input$prevalence_gt_prev1_download_type),
    content = function(file) {
      obj <- createOutputprev1()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## output prev2 -----
  createOutputprev2 <- shiny::reactive({
    
    if (is.null(dataFiltered$prevalence)) {
      validate("No prevalence in results")
    }
    
    result <- prevalenceFiltered()
    
    if (nrow(result) == 0) {
      validate("No results found for selected inputs")
    }
    
    IncidencePrevalence::plotPrevalence(
      result,
      x = input$prevalence_ggplot2_prev2_x,
      ribbon = input$prevalence_ggplot2_prev2_ribbon,
      facet = input$prevalence_ggplot2_prev2_facet,
      colour = input$prevalence_ggplot2_prev2_colour
    ) |>
      plotly::ggplotly()
  })
  output$prevalence_ggplot2_prev2 <- plotly::renderPlotly({
    createOutputprev2()
  })
  output$prevalence_ggplot2_prev2_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_prevalence.", "png"),
    content = function(file) {
      obj <- createOutputprev2()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$prevalence_ggplot2_prev2_download_width),
        height = as.numeric(input$prevalence_ggplot2_prev2_download_height),
        units = input$prevalence_ggplot2_prev2_download_units,
        dpi = as.numeric(input$prevalence_ggplot2_prev2_download_dpi)
      )
    }
  )
  
  
  # compare lsc ----
  
  outputLSC <- shiny::reactive({

    if (is.null(dataFiltered$summarise_large_scale_characteristics)) {
      validate("No large scale characteristics in results")
    }
    dataFiltered$summarise_large_scale_characteristics |>
      filter(variable_level %in% input$compare_large_scale_characteristics_grouping_time_window,
             cdm_name %in% input$compare_large_scale_characteristics_grouping_cdm_name) |>
      filterSettings(table_name %in% input$compare_large_scale_characteristics_grouping_domain,
                     analysis %in% input$compare_large_scale_characteristics_settings_analysis)
    
  })
  
  output$gt_compare_lsc <- DT::renderDT({
    lscFiltered <- outputLSC()
    
    if (nrow(lscFiltered) == 0) {
      validate("No results found for selected inputs")
    }
    
    target_cohort     <- input$compare_large_scale_characteristics_grouping_cohort_1
    comparator_cohort <- input$compare_large_scale_characteristics_grouping_cohort_2
    
    lsc <- lscFiltered |>
      filter(group_level %in% c(target_cohort, comparator_cohort
      )) |>
      filter(estimate_name == "percentage") |>
      omopgenerics::addSettings() |>
      select(database = cdm_name,
             cohort_name = group_level,
             variable_name,
             time_window = variable_level,
             concept_id = additional_level,
             table = table_name,
             percentage = estimate_value) |>
      mutate(percentage = if_else(percentage == "-",
                                  NA, percentage)) |>
      mutate(percentage = as.numeric(percentage)) |>
      pivot_wider(names_from = cohort_name,
                  values_from = percentage)
    
    if(isTRUE(input$compare_large_scale_characteristics_impute_missings)){
      lsc <- lsc |>
        mutate(across(c(target_cohort, comparator_cohort), ~if_else(is.na(.x), 0, .x)))
    }
    
    lsc <- lsc |>
      mutate(across(c(target_cohort, comparator_cohort), ~ as.numeric(.x)/100)) |>
      mutate(smd = (!!sym(target_cohort) - !!sym(comparator_cohort))/sqrt((!!sym(target_cohort)*(1-!!sym(target_cohort)) + !!sym(comparator_cohort)*(1-!!sym(comparator_cohort)))/2)) |>
      arrange(desc(smd))  |>
      mutate(across(c(target_cohort, comparator_cohort), ~ as.numeric(.x)*100)) |>
      mutate(concept = paste0(variable_name, " (",concept_id, ")")) |>
      select("Database" = database,
             "Concept name (concept ID)" = concept,
             "Table" = table,
             "Time window" = time_window,
             target_cohort,
             comparator_cohort,
             "Standardised mean difference" = smd)
    
    round_cols <- c("Standardised mean difference",
                    target_cohort,
                    comparator_cohort)
    
    DT::datatable(lsc, rownames= FALSE) %>%
      formatRound(columns=c(round_cols), digits=2)
    
  })
  
  
  output$plotly_compare_lsc <- renderPlotly({
    if (nrow(outputLSC()) == 0) {
      validate("No data to plot")
    }

    plotComparedLsc(lsc = outputLSC(),
                    cohorts = c(input$compare_large_scale_characteristics_grouping_cohort_1,
                                input$compare_large_scale_characteristics_grouping_cohort_2),
                    colour = c(input$compare_large_scale_characteristics_colour_1),
                    facet  = c(input$compare_large_scale_characteristics_facet_1),
                    imputeMissings = input$compare_large_scale_characteristics_impute_missings
    )
  })
  
  # orphan -----
  ## tidy orphan -----
  getTidyDataSummariseCharacteristics <- shiny::reactive({
    res <- dataFiltered$orphan |>
      filterData("orphan", input) |>
      tidyData()
    
    # columns to eliminate
    colsEliminate <- colnames(res)
    colsEliminate <- colsEliminate[!colsEliminate %in% c(
      input$orphan_tidy_columns, "variable_name", "variable_level",
      "estimate_name", "estimate_type", "estimate_value"
    )]
    
    # pivot
    pivot <- input$orphan_tidy_pivot
    if (pivot != "none") {
      vars <- switch(pivot,
                     "estimates" = "estimate_name",
                     "estimates and variables" = c("variable_name", "variable_level", "estimate_name")
      )
      res <- res |>
        visOmopResults::pivotEstimates(pivotEstimatesBy = vars)
    }
    
    res |>
      dplyr::select(!dplyr::all_of(colsEliminate))
  })
  output$orphan_tidy <- DT::renderDT({
    DT::datatable(
      getTidyDataSummariseCharacteristics(),
      options = list(scrollX = TRUE),
      rownames = FALSE
    )
  })
  output$orphan_tidy_download <- shiny::downloadHandler(
    filename = "tidy_orphan.csv",
    content = function(file) {
      getTidyDataSummariseCharacteristics() |>
        readr::write_csv(file = file)
    }
  )
  ## output orphan -----
  ## output 99 -----
  createOutput99 <- shiny::reactive({
    
    if (is.null(dataFiltered$prevalence)) {
      validate("No orphan codes in results")
    }
    
    if (is.null(dataFiltered$orphan_code_use)) {
      validate("No orphan codes in results")
    }
    
    result <- dataFiltered$orphan_code_use |>
      dplyr::filter(cdm_name %in% input$orphan_grouping_cdm_name,
                    group_level %in% input$orphan_grouping_codelist_name)
    tbl <- CodelistGenerator::tableOrphanCodes(
      result,
      header = input$orphan_gt_99_header,
      groupColumn = input$orphan_gt_99_groupColumn,
      hide = input$orphan_gt_99_hide
    )
    
    tbl %>%
      tab_header(
        title = "Summary of orphan codes",
        subtitle = "Orphan codes refer to concepts present in the database that are not in a codelist but are related to included codes."
      ) %>%
      tab_options(
        heading.align = "left"
      )
    
  })
  output$orphan_gt_99 <- gt::render_gt({
    createOutput99()
  })
  output$orphan_gt_99_download <- shiny::downloadHandler(
    filename = paste0("output_gt_orphan.", input$orphan_gt_99_download_type),
    content = function(file) {
      obj <- createOutput99()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  ## unmapped codes -----
  ## output orphan -----
  ## output 99 -----
  createOutputUnmapped <- shiny::reactive({
    if (is.null(dataFiltered$unmapped_codes)) {
      validate("No unmapped codes in results")
    }
    
    CodelistGenerator::tableUnmappedCodes(
      dataFiltered$unmapped_codes |>
        dplyr::filter(cdm_name %in% input$unmapped_grouping_cdm_name,
                      group_level %in% input$unmapped_grouping_codelist_name),
      header = input$unmapped_header,
      groupColumn = input$unmapped_groupColumn,
      hide = input$unmapped_hide
    ) %>%
      tab_header(
        title = "Summary of unmapped codes",
        subtitle = "These codes are recorded as source concepts that are mapped to 0"
      ) %>%
      tab_options(
        heading.align = "left"
      )
  })
  output$unmapped_formatted <- gt::render_gt({
    createOutputUnmapped()
  })
  output$unmapped_formatted_download <- shiny::downloadHandler(
    filename = paste0("output_gt_orphan.", input$unmapped_formatted_download_type),
    content = function(file) {
      obj <- createOutputUnmapped()
      gt::gtsave(data = obj, filename = file)
    }
  )
  
  
  
  ## age distribution ----
  ## output table ----
  createAgePyramid <- shiny::reactive({
    
    summarise_table <- dataFiltered$summarise_table |>
      filter(cdm_name %in% input$summarise_characteristics_grouping_cdm_name,
             group_level %in% input$summarise_characteristics_grouping_cohort_name) 
    
    summarise_characteristics <- dataFiltered$summarise_characteristics |>
      filter(cdm_name %in% input$summarise_characteristics_grouping_cdm_name,
             group_level %in% input$summarise_characteristics_grouping_cohort_name)
    
    plotAgeDensity(summarise_table, summarise_characteristics)
   
  })
  
  output$plot_age_pyramid <- shiny::renderPlot({
    createAgePyramid()
  })
  
  output$plot_age_pyramid_download <- shiny::downloadHandler(
    filename = paste0("output_ggplot2_age_pyramid.", "png"),
    content = function(file) {
      obj <- createAgePyramid()
      ggplot2::ggsave(
        filename = file,
        plot = obj,
        width = as.numeric(input$plot_age_pyramid_download_width),
        height = as.numeric(input$plot_age_pyramid_download_height),
        units = input$plot_age_pyramid_download_units,
        dpi = as.numeric(input$plot_age_pyramid_download_dpi)
      )
    }
  )
  
}
