% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_pie_glyph.R
\name{scale_radius_discrete}
\alias{scale_radius_discrete}
\alias{scale_radius_manual}
\alias{scale_radius_continuous}
\alias{scale_radius}
\title{Scales for the pie glyph radius}
\usage{
scale_radius_discrete(..., range = c(0.25, 0.6), unit = "cm")

scale_radius_manual(..., values, unit = "cm", breaks = waiver(), na.value = NA)

scale_radius_continuous(..., range = c(0.25, 0.6), unit = "cm")

scale_radius(..., range = c(0.25, 0.6), unit = "cm")
}
\arguments{
\item{...}{
  Arguments passed on to \code{\link[ggplot2:continuous_scale]{continuous_scale}}
  \describe{
    \item{\code{minor_breaks}}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation. When
the function has two arguments, it will be given the limits and major
breaks.
}}
    \item{\code{oob}}{One of:
\itemize{
\item Function that handles limits outside of the scale limits
(out of bounds). Also accepts rlang \link[rlang:as_function]{lambda}
function notation.
\item The default (\code{\link[scales:oob]{scales::censor()}}) replaces out of
bounds values with \code{NA}.
\item \code{\link[scales:oob]{scales::squish()}} for squishing out of bounds values into range.
\item \code{\link[scales:oob]{scales::squish_infinite()}} for squishing infinite values into range.
}}
    \item{\code{na.value}}{Missing values will be replaced with this value.}
    \item{\code{call}}{The \code{call} used to construct the scale for reporting messages.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}

\item{range}{a numeric vector of length 2 that specifies the minimum and
maximum size of the plotting symbol after transformation.}

\item{unit}{Unit for the radius of the pie glyphs. Default is "cm",
but other units like "in", "mm", etc. can be used.}

\item{values}{a set of aesthetic values to map data values to. The values
will be matched in order (usually alphabetical) with the limits of the
scale, or with \code{breaks} if provided. If this is a named vector, then the
values will be matched based on the names instead. Data values that don't
match will be given \code{na.value}.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:new_transform]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Note that for position scales, limits are provided after scale expansion.
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{na.value}{The aesthetic value to use for missing (\code{NA}) values}
}
\value{
A ggplot scale object adjusting the radii of the pie glyphs
}
\description{
\code{scale_radius_*()} is useful for adjusting the radius of the pie glyphs.
}
\examples{
## Load libraries
library(dplyr)
library(tidyr)
library(ggplot2)

## Simulate raw data
set.seed(789)
plot_data <- data.frame(y = rnorm(10, 100, 30),
                        x = 1:10,
                        group = sample(size = 10,
                                       x = c(1, 2, 3),
                                       replace = TRUE),
                        A = round(runif(10, 3, 9), 2),
                        B = round(runif(10, 1, 5), 2),
                        C = round(runif(10, 3, 7), 2),
                        D = round(runif(10, 1, 9), 2))

head(plot_data)

## Create plot
p <- ggplot(data = plot_data)+
    geom_pie_glyph(aes(x = x, y = y, radius = group),
                   slices = c('A', 'B', 'C', 'D'))+
    labs(y = 'Response', x = 'System',
         fill = 'Attributes')+
    theme_classic()

p + scale_radius_continuous(range = c(0.2, 0.5))

q <- ggplot(data = plot_data)+
    geom_pie_glyph(aes(x = x, y = y,
                       radius = as.factor(group)),
                   slices = c('A', 'B', 'C', 'D'))+
    labs(y = 'Response', x = 'System',
         fill = 'Attributes', radius = 'Group')+
    theme_classic()

q + scale_radius_discrete(range = c(0.05, 0.2), unit = 'in',
                          name = 'Group')

q + scale_radius_manual(values = c(2, 6, 4), unit = 'mm',
                        labels = paste0('G', 1:3), name = 'G')
}
