% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group.rankings.R
\name{group}
\alias{group}
\alias{as.grouped_rankings}
\alias{as.grouped_rankings.paircomp}
\alias{[.grouped_rankings}
\alias{format.grouped_rankings}
\title{Group Rankings}
\usage{
group(x, index, ...)

as.grouped_rankings(x, ...)

\method{as.grouped_rankings}{paircomp}(x, ...)

\method{[}{grouped_rankings}(x, i, j, ..., drop = TRUE,
  as.grouped_rankings = TRUE)

\method{format}{grouped_rankings}(x, max = 2L, width = 20L, ...)
}
\arguments{
\item{x}{a \code{\link[=rankings]{"rankings"}} object for \code{group()}; an
object that can be coerced to a \code{"grouped_rankings"} object for
\code{as.grouped_rankings()}, otherwise a \code{"grouped_rankings"} object.}

\item{index}{a numeric vector of length equal to the number of rankings
specifying the subject for each ranking.}

\item{...}{additional arguments passed on to \code{\link{as.rankings}}
by \code{grouped_rankings} or \code{as.grouped_rankings}; unused by
\code{format}.}

\item{i}{indices specifying groups to extract, may be any data type accepted
by \code{\link{[}}.}

\item{j}{indices specifying items to extract, as for \code{\link{[}}.}

\item{drop}{if \code{TRUE} return single row/column matrices as a vector.}

\item{as.grouped_rankings}{if \code{TRUE} return a grouped_rankings object,
otherwise return a matrix/vector.}

\item{max}{the maximum number of rankings to format per subject.}

\item{width}{the maximum width in number of characters to format each
ranking.}
}
\value{
An object of class \code{"grouped_rankings"}, which is a vector of
of group IDs with the following attributes:
\item{rankings}{ The \code{"rankings"} object.}
\item{index}{ An index match each ranking to each group ID.}
\item{R}{ A matrix with items ordered from last to first place, for each
ranking. }
\item{S}{ The rankings matrix with the ranks replaced by the size of the
chosen set for free choices and zero for forced choices. }
\item{id}{ A list with elements of the adjacency matrix that are incremented
by each ranking. }
}
\description{
Create an object of class \code{"grouped_rankings"} which associates a
group index with an object of class \code{"rankings"}. This allows the
rankings to be linked to covariates with group-specific values as the basis
for model-based recursive partitioning, see \code{\link{pltree}}.
}
\examples{

# ungrouped rankings (5 rankings, 4 items)
R <- as.rankings(matrix(c(1, 2, 0, 0,
                          0, 2, 1, 0,
                          0, 0, 1, 2,
                          2, 1, 0, 0,
                          0, 1, 2, 3), ncol = 4, byrow = TRUE))
length(R)
R

# group rankings (first three in group 1, next two in group 2)
G <- group(R, c(1, 1, 1, 2, 2))
length(G)

## by default up to 2 rankings are shown per group, "..." indicates if
## there are further rankings
G
print(G, max = 1)

## select rankings from group 1
G[1,]

## exclude item 3 from ranking
G[, -3]

## rankings from group 2, excluding item 3
## - note group 2 becomes the first group
G[2, -3]

## index underlying rankings without creating new grouped_rankings object
G[2, -3, as.grouped_rankings = FALSE]
}
\seealso{
\code{\link{pltree}}
}
