% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Intersections.R
\name{intersectionCircleLine}
\alias{intersectionCircleLine}
\title{Intersection of a circle and a line}
\usage{
intersectionCircleLine(circ, line, strict = FALSE)
}
\arguments{
\item{circ}{a \code{Circle} object}

\item{line}{a \code{Line} object}

\item{strict}{logical, whether to take into account \code{line$extendA} and
\code{line$extendB} if they are not both \code{TRUE}}
}
\value{
\code{NULL} if there is no intersection;
a point if the infinite line is tangent to the circle, or \code{NULL}
if \code{strict=TRUE} and the point is not on the line (segment or half-line);
a list of two points if the circle and the infinite line meet at
two points, when \code{strict=FALSE}; if \code{strict=TRUE} and the line is
a segment or a half-line, this can return \code{NULL} or a single point.
}
\description{
Return the intersection of a circle and a line.
}
\examples{
circ <- Circle$new(c(1,1), 2)
line <- Line$new(c(2,-2), c(1,2), FALSE, FALSE)
intersectionCircleLine(circ, line)
intersectionCircleLine(circ, line, strict = TRUE)
}
