% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{maxAreaInscribedEllipse}
\alias{maxAreaInscribedEllipse}
\title{Maximum area ellipse inscribed in a convex polygon}
\usage{
maxAreaInscribedEllipse(points, verbose = FALSE)
}
\arguments{
\item{points}{the vertices of the polygon in a two-columns matrix; their
order has no importance, since the procedure takes the convex hull of
these points (and does not check the convexity)}

\item{verbose}{argument passed to \code{\link[CVXR:psolve]{psolve}}}
}
\value{
An \code{Ellipse} object. The status of the optimization problem
  is given as an attribute of this ellipse. A warning is thrown if it is
  not optimal.
}
\description{
Computes the ellipse inscribed in a convex polygon with
  maximum area.
}
\examples{
hexagon <- rbind(
  c(-1.7, -1),
  c(-1.4, 0.4),
  c(0.3, 1.3),
  c(1.7, 0.6),
  c(1.3, -0.3),
  c(-0.4, -1.8)
)
opar <- par(mar = c(2, 2, 1, 1))
plot(NULL, xlim=c(-2, 2), ylim=c(-2, 2), xlab = NA, ylab = NA, asp = 1)
points(hexagon, pch = 19)
polygon(hexagon)
ell <- maxAreaInscribedEllipse(hexagon)
draw(ell, col = "yellow2", border = "blue", lwd = 2)
par(opar)
# check optimization status:
attr(ell, "status")
}
\seealso{
\code{\link{maxAreaInscribedCircle}}
}
