% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reflection.R
\name{Reflection}
\alias{Reflection}
\title{R6 class representing a reflection}
\description{
A reflection is given by a line.
}
\examples{

## ------------------------------------------------
## Method `Reflection$new`
## ------------------------------------------------

l <- Line$new(c(1,1), c(1.5,1.5), FALSE, TRUE)
Reflection$new(l)

## ------------------------------------------------
## Method `Reflection$getMatrix`
## ------------------------------------------------

R <- Reflection$new(Line$new(c(2,2), c(4,5)))
P <- c(1,5)
R$reflect(P)
R$getMatrix() \%*\% c(P,1)
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{line}}{get or set the line of the reflection}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Reflection-new}{\code{Reflection$new()}}
\item \href{#method-Reflection-print}{\code{Reflection$print()}}
\item \href{#method-Reflection-reflect}{\code{Reflection$reflect()}}
\item \href{#method-Reflection-transform}{\code{Reflection$transform()}}
\item \href{#method-Reflection-reflectCircle}{\code{Reflection$reflectCircle()}}
\item \href{#method-Reflection-transformCircle}{\code{Reflection$transformCircle()}}
\item \href{#method-Reflection-reflectLine}{\code{Reflection$reflectLine()}}
\item \href{#method-Reflection-transformLine}{\code{Reflection$transformLine()}}
\item \href{#method-Reflection-getMatrix}{\code{Reflection$getMatrix()}}
\item \href{#method-Reflection-asAffine}{\code{Reflection$asAffine()}}
\item \href{#method-Reflection-clone}{\code{Reflection$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-new"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{Reflection} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$new(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Reflection} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{l <- Line$new(c(1,1), c(1.5,1.5), FALSE, TRUE)
Reflection$new(l)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-print"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-print}{}}}
\subsection{Method \code{print()}}{
Show instance of a reflection object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-reflect"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-reflect}{}}}
\subsection{Method \code{reflect()}}{
Reflect a point.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflect(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point, \code{Inf} allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-transform"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-transform}{}}}
\subsection{Method \code{transform()}}{
An alias of \code{reflect}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transform(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point, \code{Inf} allowed}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-reflectCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-reflectCircle}{}}}
\subsection{Method \code{reflectCircle()}}{
Reflect a circle.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflectCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-transformCircle"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-transformCircle}{}}}
\subsection{Method \code{transformCircle()}}{
An alias of \code{reflectCircle}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transformCircle(circ)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{circ}}{a \code{Circle} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Circle} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-reflectLine"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-reflectLine}{}}}
\subsection{Method \code{reflectLine()}}{
Reflect a line.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$reflectLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-transformLine"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-transformLine}{}}}
\subsection{Method \code{transformLine()}}{
An alias of \code{reflectLine}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$transformLine(line)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{line}}{a \code{Line} object}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-getMatrix"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-getMatrix}{}}}
\subsection{Method \code{getMatrix()}}{
Augmented matrix of the reflection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$getMatrix()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A 3x3 matrix.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{R <- Reflection$new(Line$new(c(2,2), c(4,5)))
P <- c(1,5)
R$reflect(P)
R$getMatrix() \%*\% c(P,1)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-asAffine"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-asAffine}{}}}
\subsection{Method \code{asAffine()}}{
Convert the reference reflection to an \code{Affine} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$asAffine()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Reflection-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Reflection-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Reflection$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
