% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlasmodeSur.R
\name{PlasmodeSur}
\alias{PlasmodeSur}
\title{Performs the plasmode simulation}
\usage{
PlasmodeSur(formulaOut = NULL, formulaCen = NULL, objectOut = NULL,
  objectCen = NULL, formulaExp = NULL, objectExp = NULL, data, idVar,
  effectOR = 1, MMOut = 1, MMExp = 1, nsim, size, eventRate = NULL,
  exposedPrev = NULL)
}
\arguments{
\item{formulaOut}{An outcome model formula for estimating the hazard of outcome event.The functional form of the outcome model should be, Surv(data$time, data$event)~ Exposure + Confounders, where data is the dataset on which simulations are based, time is the follow-up time for the right-censored data and event is the status indicator. Exposure main effect must be first independent variable.}

\item{formulaCen}{An outcome model formula for estimating the hazard of censoring.The functional form of the outcome model should be, Surv(data$time, !data$event)~ Exposure + Confounders, where data is the dataset on which simulations are based, time is the follow-up time for the right-censored data and event is the status indicator. Exposure main effect must be first independent variable.}

\item{objectOut}{A fitted model object for the hazard of outcome.The functional form of the fitted model object should be of form coxph(Surv(data$time, data$event)~ Exposure + Confounders, data,x=TRUE), where coxph fits the Cox proportional hazard model, data is the dataset on which simulations are based, time is the follow-up time for the right-censored data and event is the status indicator. Exposure main effect must be first independent variable.}

\item{objectCen}{A fitted model object for the hazard of censoring.The functional form of the fitted model object should be of form coxph(Surv(data$time, !data$event)~ Exposure + Confounders, data,x=TRUE), where coxph fits the Cox proportional hazard model, data is the dataset on which simulations are based, time is the follow-up time for the right-censored data and event is the status indicator. Exposure main effect must be first independent variable.}

\item{formulaExp}{An exposure model formula containing the binary exposure on the left-hand side and potential confounders on the right-hand side. The functional form of the exposure model is, Exposure ~ Confounders.}

\item{objectExp}{A fitted model object for the exposure model.}

\item{data}{The dataset on which simulations are based.The data is required only when formulaOut, formulaCen or formulaExp or both are supplied to the argument.}

\item{idVar}{Name of the ID variable}

\item{effectOR}{The desired treatment effect odds ratio. By default effectOR = 1.}

\item{MMOut}{Multiplier of confounder effects on outcome on the log-scale. By default MMOut = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the outcome model.}

\item{MMExp}{Multiplier of confounder effects on exposure. By default MMExp = 1 but one can specify a vector of length equivalent to the number of variables on the right-hand side of the exposure model.}

\item{nsim}{Number of desired simulated datasets.}

\item{size}{Desired size of simulated datasets (i.e., # of individuals).}

\item{eventRate}{Desired average event rate. Default is the event rate in the observed data.}

\item{exposedPrev}{Desired average exposure rate. Default is the exposure prevalence in the observed data.}
}
\value{
PlasmodeSur returns true beta coefficients used to generate the outcome and the exposure. PlasmodeSur also returns the data frame with the simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.
\item{TrueOutBeta}{True beta coefficients used to generate the outcome.}
\item{TrueExpBeta}{True beta coefficients used to generate the exposure.}
\item{Sim_Data}{Plasmode simulated data, including sampled IDs for each of nsim datasets along with simulated outcomes, exposure, or both.}
}
\description{
Creates 'plasmode' simulated datasets based on a given dataset when the outcome variable is time to event and exposure variable are binary. Plasmode simulation samples subjects with replacement from the observed data, uses subjects’ covariate data as is, and simulates exposure, outcome, or both.
}
\details{
At least one of formulaOut, formulaCen, formulaExp, objectOut,objectCen, and objectExp must be specified, and which of these are specified will determine what gets simulated and how. If objectOut and objectCen or objectExp are specified, these objects are used as the base model for outcome and exposure simulation. If formulaOut and formulaCen or formulaExp are specified, then data should be given and base models are fit in the data using coxph with the given formulas. If formulaOut and formulaCen or objectOut and objectCen is specified, outcome will be simulated based on subjects’ observed exposure. If formulaExp or objectExp is specified, exposure will be simulated. And if models are specified for both outcome and exposure, both variables will be simulated with simulated outcome dependent on the simulated exposure.
}
\examples{
{
library(survival)
library(splines)
library(glm2)
## Creating data set for simulation
lung <- lung[complete.cases(lung),]
lung$id <- 1:nrow(lung)
lung$meal.cal <- ifelse(lung$meal.cal > 1000, 1, 0)
lung$status <- lung$status - 1

## Formulas for estimating the hazard of outcome event, the hazard of censoring and exposure.

form1<-Surv(lung$time, lung$status)~meal.cal+age+sex+ph.ecog+ph.karno
form2<-Surv(lung$time, !lung$status)~meal.cal+age+sex+ph.ecog+ph.karno
form3<- meal.cal~age+sex+ph.ecog+ph.karno

Sur_Form1<-PlasmodeSur(formulaOut=form1,formulaCen=form2, objectOut=NULL, objectCen = NULL,
            formulaExp=form3,objectExp=NULL,data=lung,idVar="id",effectOR =1, MMOut=c(0.5,2,2,1,3),
            MMExp=c(2,2,2,2), nsim=3, size=nrow(lung), eventRate=NULL, exposedPrev=NULL)

Sur_Form2<-PlasmodeSur(formulaOut=form1,formulaCen=form2, objectOut=NULL, objectCen = NULL,
            formulaExp=NULL,objectExp=NULL,data=lung,idVar="id",effectOR =1, MMOut=c(1,2,2,1,3),
            MMExp=c(1,1,1,1),nsim=3, size=nrow(lung), eventRate=NULL, exposedPrev=NULL)

Sur_Form3<-PlasmodeSur(formulaOut=NULL,formulaCen=NULL, objectOut=NULL, objectCen = NULL,
            formulaExp=form3,objectExp=NULL,data=lung,idVar="id",effectOR =1, MMOut=c(1,2,2,1,3),
            MMExp=c(1,1,1,1),nsim=3, size=nrow(lung), eventRate=NULL, exposedPrev=NULL)

## Objects for the hazard of the outcome event, hazard for censoring and the exposure.

smod1 <- coxph(Surv(lung$time, lung$status)~meal.cal+age+sex+ph.ecog+ph.karno, data = lung,x=TRUE)
smod2 <- coxph(Surv(lung$time, !lung$status)~meal.cal+age+sex+ph.ecog+ph.karno, data = lung,x=TRUE)
pmod1<-glm2(meal.cal~age+sex+ph.ecog+ph.karno, data = lung,family = "binomial",
            control=glm.control(trace=TRUE))

Sur_Obj1<-PlasmodeSur(formulaOut=NULL,formulaCen=NULL, objectOut=smod1,objectCen = smod2,
            formulaExp=NULL,objectExp=pmod1,idVar=lung$id, effectOR =1, MMOut=c(1,2,2,1,3),
            MMExp=1, nsim=3,size=nrow(lung), eventRate=0.5, exposedPrev=NULL)

Sur_Obj2<-PlasmodeSur(formulaOut=NULL,formulaCen=NULL, objectOut=smod1,objectCen = smod2,
            formulaExp=NULL,objectExp=NULL,idVar=lung$id, effectOR =1.5, MMOut=c(1,2,2,1,3),
            MMExp=1, nsim=3,size=nrow(lung), eventRate=0.5, exposedPrev=NULL)

Sur_Obj3<-PlasmodeSur(formulaOut=NULL,formulaCen=NULL, objectOut=NULL,objectCen = NULL,
            formulaExp=NULL,objectExp=pmod1,idVar=lung$id,effectOR =1, MMOut=c(1,2,2,1,3),
            MMExp=1, nsim=3,size=nrow(lung), eventRate=0.5, exposedPrev=NULL)
}
}
\author{
Jessica M. Franklin, Younathan Abdia, and Shirley Wang
}
