% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_coexpression_coefficient.R
\name{GEX_coexpression_coefficient}
\alias{GEX_coexpression_coefficient}
\title{Coexpression of selected genes}
\usage{
GEX_coexpression_coefficient(GEX, genes, subsample.n, plot.dotmap)
}
\arguments{
\item{GEX}{GEX seurat object generated with VDJ_GEX_matrix (VDJ_GEX_matrix.output\[\[2\]\])}

\item{genes}{Character vector. At least 2 genes present in rownames(GEX). Use "all" to include all genes. The number of comparisons to make is the length(genes)! (factorial). More than 100 genes are not recommended.}

\item{subsample.n}{Interger. Number of cells to subsample. If set to 100, 100 cells will be randomly sampled for the calculation}

\item{plot.dotmap}{Boolean. Whether to return a plot}
}
\value{
Returns a dataframe if pot.dotmap == F or a ggplot if plot.dotmap == T detailing the coexpression levels of selected genes within the given cell population
}
\description{
Returns eiter a plot or numeric data of coexpression levels of selected genes.Coexpression \% is calculated as the quotient of double positive cells (counts \> 0) and the sum of total cells positive for either genes.
}
\examples{
#To return a dataframe with coefficients
#GEX_coexpression_coefficient(GEX = VDJ_GEX_matrix.output[[2]]
#, genes = c("CD19", "EBF1","SDC1"), subsample.n = "none", plot.dotmap = FALSE)

#To return a dotplot detailing coexpression and overall expression
GEX_coexpression_coefficient(GEX = Platypus::small_vgm[[2]]
, genes = c("CD19", "CD83"), subsample.n = "none", plot.dotmap = FALSE)
}
