% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AbForests_ForestMetrics.R
\name{AbForests_ForestMetrics}
\alias{AbForests_ForestMetrics}
\title{Calculate metrics for networks}
\usage{
AbForests_ForestMetrics(
  graphs,
  DAG,
  clonal_frequency,
  scaleByClonalFreq,
  weight,
  tie_flag,
  opt
)
}
\arguments{
\item{graphs}{A list of lists. Each sublist contains an igraph object with the networks of the evolved B clonal lineages in tree format, their legend and the number of randomly considered nodes per network(Output of AntibodyForest function).
E.g graphs[[1][[1]] is an igraph object, containing the first network of the evolved B clonal lineage in tree format.
graphs[[1]][[2]] contains the legend parameters of the first network of the evolved B clonal lineage.
graphs[[1]][[3]] is the number of randomly considered nodes for the first network of the evolved B clonal lineage.}

\item{DAG}{a logical variable, when TRUE a directed acyclic graph is produced.}

\item{clonal_frequency}{a logical variable, TRUE if labeling of vertices is based on clonal frequency and FALSE otherwise.}

\item{scaleByClonalFreq}{logical variable with TRUE if vertex size is scaled by the number of unique sequences per clone and FALSE otherwise.}

\item{weight}{logical variable. When its value is FALSE, then the weights of outgoing edges from Germline node are set to 1. When its value is TRUE, the weights are set to the difference between the number of mutations among sequences in germline and connected nodes(value in the corresponding distance matrix) and the absolute value of the difference between the sequence lengths of germline and corresponding connected nodes. In both cases, weights of remaining edges are extracted from the distance matrix.
Outgoing edges from Germline represent the number of mutations of sequences having as common ancestor the Germline.}

\item{tie_flag}{a string, with options 'rand', 'full', 'close_to_germ', 'far_from_germ', 'close_path_to_germ', 'far_path_from_germ','most_expanded' and 'least_expanded' for removing edges when equal distance (tie) in distance matrix.
'rand' means random pruning in one of nodes, 'full' means keeping all nodes, close_to_germ means pruning of node(s) farthest from germline (based on number of intermediate nodes), 'far_from_germ' means pruning of node(s) closest to germline (based on number of intermediate nodes),
'close_path_to_germ' means pruning of node(s) farthest from germline (based on edge path length), 'far_path_from_germ' meams pruning of node(s) closest to germline (based on edge path length),'most_expanded' means pruning of node(s) with the lowest B cell count(clonal frequency) and least_expanded, which means pruning of node(s) with the hightest B cell count(clonal frequency). In cases of subsequent ties, a random node is selected.}

\item{opt}{a string with options "isotype" and "cluster". The option "isotype" is utilized when the user desires to do an isotype analysis, while the selection of "cluster" denotes that an analysis based on transcriptome is requested.}
}
\value{
metrics.  A list of lists. Each list contains various metrics for the quantification of networks.
E.g metrics[[1][[1]] is the weighted Longest path from germline for the first network.
metrics[[1]][[2]] is the length of weighted longest shortest path from germline for the first network.
metrics[[1]][[3]] is the unweighted Longest path from germline for the first network.
metrics[[1]][[4]] is the length of unweighted longest shortest path from germline for the first network.
metrics[[1]][[5]] is the weighted shortest path network for the first network.
metrics[[1]][[6]] is the uweighted shortest path network for the first network.
metrics[[1]][[7]] is the average number of daughter cells for the first network.
metrics[[1]][[8]] is the std number of daughter cells for the first network.
metrics[[1]][[9]] is the min number of daughter cells for the first network.
metrics[[1]][[10]] is the max number of daughter cells for the first network.
metrics[[1]][[11]] is a ggplot object that contains the plot of Degree Distribution of daughter cells for the first network.
metrics[[1]][[12]] is the weighted vertex degree for the first network.
metrics[[1]][[13]] is a ggplot object that contains the plot of unweighted Degree Distribution of daughter cells for the first network.
metrics[[1]][[14]] is the average number of isotypes for the first network.
metrics[[1]][[15]] is a ggplot object that contains the plot of Distribution of isotypes for the first network.
metrics[[1]][[16]] is the Isotypes/Clusters info data.frame with columns Parent, Child and Parent-Child, which contains the type of isotypes/clusters for each pair of nodes (Parent-Child relationship in tree) found in the first network.
metrics[[1]][[17]] is a ggplot object that contains the plot of Isotype/Cluster Directionality for the first network. In particular, the frequency of all types of isotypes/clusters for each pair of nodes in the tree is depicted.
metrics[[1]][[18]] is the vertex betweenness centrality for the first network. It is defined by the number of geodesics (shortest paths) going through a vertex according to igraph documentation.
metrics[[1]][[19]] is the edge betweenness centrality for the first network. It is defined by the number of geodesics (shortest paths) going through an edge according to igraph documentation.
metrics[[1]][[20]] is the closeness centrality of vertices for the first network. The closeness centrality of a vertex is defined by the inverse of the average length of the shortest paths to/from all the other vertices in the graph according to igraph documentation.
metrics[[1]][[21]] is a ggplot object that contains the plot of Path length from Germline vs Node Degree for the first network.
metrics[[1]][[22]] is a ggplot object that contains the plot of Number of edges from Germline vs Node Degree for the first network.
metrics[[1]][[23]] is an igraph object that contains the Isotype/Cluster transition network for the first network.
metrics[[1]][[24]] is the global clustering coefficient for the first network.
metrics[[1]][[25]] is the average clustering coefficient for the first network.
metrics[[1]][[26]] is the mean clonal expansion for the first network, calculated as the mean of clonal frequencies of all vertices in the network.
If the labeling or scaling of nodes in graph is based on clonal frequency (arguments: clonal_frequency==TRUE or scaleByClonalFreq==TRUE), then
metrics[[1]][[27]] is the ratio: Number of edges from germline to each node with clonal frequency for the first network.
metrics[[1]][[28]] is the mean ratio: Number of edges from germline to each node with clonal frequency for the first network.
metrics[[1]][[29]] is a ggplot object that contains the ratio of Number of edges from germline to each node with clonal frequency for the first network.
metrics[[1]][[30]] is the mean number of edges from germline for the first network.
metrics[[1]][[31]] is the ratio: Total path length from germline to each node with clonal frequency for the first network.
metrics[[1]][[32]] is the mean ratio: Total path length from germline to each node with clonal frequency for the first network.
metrics[[1]][[33]] is a ggplot object that contains the ratio of Total path length from germline to each node with clonal frequency for the first network.
metrics[[1]][[34]] is the mean Total path length from germline for the first network.
metrics[[2]][[1]] is the weighted Longest path from germline for the second network.
}
\description{
ForestMetrics takes the output of AntibodyForest and calculates metrics for each of the networks.
}
\examples{
\dontrun{
ForestMetrics(graphs,DAG=TRUE,clonal_frequency=TRUE,scaleByClonalFreq=TRUE,
weight=TRUE,tie_flag='close_to_germ',opt="cluster")
}
}
\seealso{
AntibodyForest
}
