% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automate_GEX.R
\name{automate_GEX}
\alias{automate_GEX}
\title{GEX processing wrapper in Platypus V2}
\usage{
automate_GEX(
  GEX.outs.directory.list,
  GEX.list,
  integration.method,
  VDJ.gene.filter,
  mito.filter,
  norm.scale.factor,
  n.feature.rna,
  n.count.rna.min,
  n.count.rna.max,
  n.variable.features,
  cluster.resolution,
  neighbor.dim,
  mds.dim,
  groups
)
}
\arguments{
\item{GEX.outs.directory.list}{The path to the output of cellranger vdj runs. Multiple repertoires to be integrated together should be supplied as a character vector in the first element of a list. For example, if two separate VDJ repertoires should be integrated together (e.g. on the same tSNE plot), GEX.outs.directory.list[[1]] <- c("my.VDJ1.path/outs/","my.VDJ2.path/outs/") should be stored as input. If these repertoires should be analyzed separately, >GEX.outs.directory.list[[1]] <-  "my.VDJ1.path/outs/"  >GEX.outs.directory.list[[2]] <-  "my.VDJ2.path/outs/"  should be supplied..
This can be left blank if supplying the clonotypes and all_contig files diretly as input. Multiple analyses can be stored}

\item{GEX.list}{List containing the output from Seurat Read10x. This must be supplied if GEX.out.directory is not provided.}

\item{integration.method}{String specifying which data normalization and integration pipeline should be used. Default is "scale.data", which correspondings to the ScaleData function internal to harmony package. 'sct'specifies SCTransform from the Seurat package. "harmony" should be specificied to perform harmony integration. This method requires the harmony package from bioconductor.}

\item{VDJ.gene.filter}{Logical indicating if variable genes from the b cell receprot and t cell receptor should be removed from the analysis. True is highly recommended to avoid clonal families clustering together.}

\item{mito.filter}{Numeric specifying which percent of genes are allowed to be composed of mitochondrial genes. This value may require visual inspection and can be specific to each sequencing experiment. Users can visualize the percentage of genes corresponding to mitochondrial genes using the function "investigate_mitochondial_genes".}

\item{norm.scale.factor}{Scaling factor for the standard Seurat pipeline. Default is set to 10000 as reported in Seurat documentation.}

\item{n.feature.rna}{Numeric that specifies which cells should be filtered out due to low number of detected genes. Default is set to 0. Seurat standard pipeline uses 2000.}

\item{n.count.rna.min}{Numeric that specifies which cells should be filtered out due to low RNA count.Default is set to 0. Seurat standard pipeline without VDJ information uses 200.}

\item{n.count.rna.max}{Numeric that specifies which cells should be filtered out due to high RNA count.Default is set to infinity. Seurat standard pipeline without VDJ information uses 2500.}

\item{n.variable.features}{Numeric specifying the number of variable features. Default set to 2000 as specified in Seurat standard pipeline.}

\item{cluster.resolution}{Numeric specifying the resolution that will be supplied to Seurat's FindClusters function. Default is set to 0.5. Increasing this number will increase the number of distinct Seurat clusters. Suggested to examine multiple parameters to ensure gene signatures differentiating clusters remains constant.}

\item{neighbor.dim}{Numeric vector specifying which dimensions should be supplied in the FindNeighbors function from Seurat. Default input is '1:10'.}

\item{mds.dim}{Numeric vector specifying which dimensions should be supplied into dimensional reduction techniques in Seurat and Harmony. Default input is '1:10'.}

\item{groups}{Integer specifying the groups of the different samples. This is needed if there are multiple biological replicates for a given condition sequenced and aligned through cellranger separately.}
}
\value{
Returns a processed Seurat object containing transcriptional information from all samples which can be supplied to the VDJ_GEX_integrate function.
}
\description{
Automates the transcriptional analysis of the gene expression libraries from cellranger. This function will integrate multiple samples
}
\examples{
\dontrun{
automate_GEX(out_directory=fullRepertoire.output,
 rep.size=3*length(unlist(fullRepertoire.output[[1]])),
 distribution="identical",
 with.germline="FALSE")
}


}
