% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruSDM_predict.R, R/modISDM_predict.R,
%   R/modMarks_predict.R, R/modSpecies_predict.R
\name{predict.bruSDM}
\alias{predict.bruSDM}
\alias{predict.modISDM}
\alias{predict.modMarks}
\alias{predict.modSpecies}
\title{Generic predict function for \code{bru_SDM} objects.}
\usage{
\method{predict}{bruSDM}(
  object,
  data = NULL,
  formula = NULL,
  mesh = NULL,
  mask = NULL,
  temporal = FALSE,
  covariates = NULL,
  spatial = FALSE,
  intercepts = FALSE,
  datasets = NULL,
  species = NULL,
  marks = NULL,
  biasfield = FALSE,
  biasnames = NULL,
  predictor = FALSE,
  fun = "linear",
  format = "sf",
  ...
)

\method{predict}{modISDM}(
  object,
  data = NULL,
  formula = NULL,
  mesh = NULL,
  mask = NULL,
  covariates = NULL,
  spatial = FALSE,
  intercepts = FALSE,
  datasets = NULL,
  bias = FALSE,
  biasnames = NULL,
  predictor = FALSE,
  fun = "linear",
  ...
)

\method{predict}{modMarks}(
  object,
  data = NULL,
  formula = NULL,
  mesh = NULL,
  mask = NULL,
  covariates = NULL,
  spatial = FALSE,
  intercepts = FALSE,
  datasets = NULL,
  marks = NULL,
  bias = FALSE,
  biasnames = NULL,
  predictor = FALSE,
  fun = "linear",
  ...
)

\method{predict}{modSpecies}(
  object,
  data = NULL,
  formula = NULL,
  mesh = NULL,
  mask = NULL,
  covariates = NULL,
  spatial = FALSE,
  intercepts = FALSE,
  datasets = NULL,
  species,
  bias = FALSE,
  biasnames = NULL,
  predictor = FALSE,
  fun = "linear",
  ...
)
}
\arguments{
\item{object}{A \code{modSpecies} object.}

\item{data}{Data containing points of the map with which to predict on. May be \code{NULL} if one of \code{mesh} or \code{mask} is \code{NULL}.}

\item{formula}{Formula to predict. May be \code{NULL} if other arguments: \code{covariates}, \code{spatial}, \code{intercepts} are not \code{NULL}.}

\item{mesh}{An \code{inla.mesh} object.}

\item{mask}{A mask of the study background. Defaults to \code{NULL}.}

\item{temporal}{Make predictions for the temporal component of the model.}

\item{covariates}{Name of covariates to predict.}

\item{spatial}{Logical: include spatial effects in prediction. Defaults to \code{FALSE}.}

\item{intercepts}{Logical: include intercept terms in prediction. Defaults to \code{FALSE}.}

\item{datasets}{Names of the datasets to include intercept and spatial term.}

\item{species}{Names of the species to predict. Default of \code{NULL} results in all species being predicted.}

\item{marks}{Names of the marks to include intercept and spatial term.}

\item{biasfield}{Logical include bias field in prediction. Defaults to \code{FALSE}.}

\item{biasnames}{Names of the datasets to include bias term. Defaults to \code{NULL}. Note: the chosen dataset needs to be run with a bias field first; this can be done using \code{.$addBias} with the object produced by \code{\link{intModel}}.}

\item{predictor}{Should all terms (except the bias terms) included in the linear predictor be used in the predictions. Defaults to \code{FALSE}.}

\item{fun}{Function used to predict. Set to \code{'linear'} if effects on the linear scale are desired.}

\item{format}{Class of the data for which to predict on. Must be one of \code{'sp'}, \code{'sf'} or \code{'terra'}. Defaults to \code{'sf'}.}

\item{...}{Additional arguments used by the inlabru \code{predict} function.}

\item{bias}{Logical include bias field in prediction. Defaults to \code{FALSE}.}
}
\value{
A list of inlabru predict objects.

A list of inlabru predict objects.

A list of inlabru predict objects.

A list of inlabru predict objects.
}
\description{
Predict function for the object produced by \code{\link{fitISDM}}. Should act identically to \pkg{inlabru}'s generic predict function if wanted, but has additional arguments to help predict certain components created by the model. This is needed since \code{\link{intModel}} creates variable names which might not be directly apparent to the user.

Predict function for the object produced by \code{\link{fitISDM}}. Should act identically to \pkg{inlabru}'s generic predict function if wanted, but has additional arguments to help predict certain components created by the model. This is needed since \code{\link{startISDM}} creates variable names which might not be directly apparent to the user.

Predict function for the object produced by \code{\link{fitISDM}}. Should act identically to \pkg{inlabru}'s generic predict function if wanted, but has additional arguments to help predict certain components created by the model. This is needed since \code{\link{startMarks}} creates variable names which might not be directly apparent to the user.

Predict function for the object produced by \code{\link{fitISDM}}. Should act identically to \pkg{inlabru}'s generic predict function if wanted, but has additional arguments to help predict certain components created by the model. This is needed since \code{\link{startSpecies}} creates variable names which might not be directly apparent to the user.
}
\details{
Predict for bru_sdm

Predict for modISDM

Predict for modMarks

Predict for modSpecies
}
\examples{

\dontrun{
 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- intModel(data, Mesh = mesh, Coordinates = c('X', 'Y'),
                             Projection = proj, responsePA = 'Present')
 
  ##Run the model
  modelRun <- fitISDM(organizedData, options = list(control.inla = list(int.strategy = 'eb')))
   
  #Predict spatial field on linear scale
  predictions <- predict(modelRun, mesh = mesh, spatial = TRUE, fun = 'linear')
   
 }
}


\dontrun{
 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- startISDM(data, Mesh = mesh,
                            Projection = proj, 
                            responsePA = 'Present')
 
  ##Run the model
  modelRun <- fitISDM(organizedData, options = list(control.inla = list(int.strategy = 'eb')))
   
  #Predict spatial field on linear scale
  predictions <- predict(modelRun, mesh = mesh, spatial = TRUE, fun = 'linear')
   
 }
}


\dontrun{
 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 data <- lapply(data, function(x) {x$mark = runif(nrow(x));x})
 mesh$crs <- proj
 
 #Set model up
 organizedData <- startMarks(data, Mesh = mesh, markNames = 'mark',
                             markFamily = 'gaussian',
                             Projection = proj, responsePA = 'Present')
 
  ##Run the model
  modelRun <- fitISDM(organizedData, options = list(control.inla = list(int.strategy = 'eb',
                                                    diagonal = 1)))
   
  #Predict spatial field on linear scale
  predictions <- predict(modelRun, mesh = mesh, marks = 'mark', fun = 'linear')
   
 }
}


\dontrun{
 
 if (requireNamespace('INLA')) {
   
 #Get Data
 data("SolitaryTinamou")
 proj <- "+proj=longlat +ellps=WGS84"
 data <- SolitaryTinamou$datasets
 mesh <- SolitaryTinamou$mesh
 mesh$crs <- proj
 
 #Set model up
 organizedData <- startSpecies(data, Mesh = mesh, speciesName = 'speciesName',
                             Projection = proj, responsePA = 'Present')
 
  ##Run the model
  modelRun <- fitISDM(organizedData, options = list(control.inla = list(int.strategy = 'eb',
                                                    diagonal = 1)))
   
  #Predict spatial field on linear scale
  predictions <- predict(modelRun, mesh = mesh, spatial = TRUE, fun = 'linear')
   
 }
}

}
