% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diversity_aid.R
\name{diversity_aid}
\alias{diversity_aid}
\title{Calculate portfolio diversity (Average Instrument Diversity)}
\usage{
diversity_aid(M)
}
\arguments{
\item{M}{Matrix with two dimensions (Instrument, Target) containing absence (0) or presence (1) of policy intervention.}
}
\value{
A value of the portfolio diversity.
}
\description{
Function used to calculate the diversity of a portfolio (Average Instrument Diversity, AID).
It is adapted from the idea of a Gini-Simpson diversity index.
The measure can be interpreted as the average probability that picking two
policy spaces from different Targets, they use a different Instrument.
}
\section{Details}{

\deqn{
\forall_{t=1..T},  \forall_{i=1..I} \sum_{c=1}^{C} \frac{c_{t,i} = c_{!t,!i}}{C}
}

where:

T are the targets covered by at least one policy instrument
I are the instruments addressing at least one policy target
C are the entirety of target-instrument-constellations

It is applied only to matrices, not to tidy objects in a proper policy portfolio.
For a proper treatment using tidy data, use it through pp_measures().
}

\examples{
data(consensus)
consensus \%>\%
  filter(Sector == "Environmental") \%>\%
  filter(Country \%in\% c("France", "United States")) \%>\%
  filter(Year \%in\% c(1976, 2005)) \%>\%
  pp_array() \%>\%
  apply(., c(1, 2, 3), diversity_aid) \%>\%
  as.vector() \%>\%
  round(digits = 3)
# 1976 (FR, US), 2005 (FR, US)
}
\references{
Fernández-i-Marín, X., Knill, C. & Steinebach, Y. (2021). Studying Policy Design Quality in Comparative Perspective. _American Political Science Review_, online first.
}
