% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{hapcomb2hapdos}
\alias{hapcomb2hapdos}
\title{convert haplotype combinations to haplotype dosages}
\usage{
hapcomb2hapdos(hapcomb, nhap)
}
\arguments{
\item{hapcomb}{matrix with <ploidy> rows and any number of columns. Each column
contains a set of haplotypes (numbers in 1 ... nhap). NAs allowed but no
values outside this range (not checked). E.g. a column with numbers
1-1-3-12 means two copies of haplotype 1 and one of haplotypes 3 and 12 each.}

\item{nhap}{the total number of possible haplotypes: 2^nmrk where nmrk is the
number of bi-allelic markers in the haploblock}
}
\value{
matrix with nhap rows (one row for each possible haplotype) and as many
columns as in hapmat, giving the dosages of each haplotype in each column
of hapmat.
}
\description{
converts matrices that contain haplotype combinations in columns
(as the matrices in ahccompletelist or ahclist) to matrices with the haplotype
dosages
}
\examples{
# specify haplotype combinations of 2 individuals:
haplocomb <- matrix(c(1,5,5,6, 5,6,6,6), ncol=2,
                   dimnames=list(NULL, c("indiv1", "indiv2")))
# convert to dosage matrix,
# assuming haploblock has 3 markers, so 8 possible haplotypes:
hapcomb2hapdos(hapcomb=haplocomb, nhap=8)
}
