% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Doptim}
\alias{Doptim}
\title{D-family optimization function}
\usage{
Doptim(poped.db, ni, xt, model_switch, x, a, bpopdescr, ddescr, maxxt, minxt,
  maxa, mina, fmf = 0, dmf = 0, trflag = TRUE,
  bUseRandomSearch = poped.db$bUseRandomSearch,
  bUseStochasticGradient = poped.db$bUseStochasticGradient,
  bUseBFGSMinimizer = poped.db$bUseBFGSMinimizer,
  bUseLineSearch = poped.db$bUseLineSearch, sgit = poped.db$sgit,
  ls_step_size = poped.db$ls_step_size,
  BFGSConvergenceCriteriaMinStep = poped.db$BFGSConvergenceCriteriaMinStep,
  BFGSProjectedGradientTol = poped.db$BFGSProjectedGradientTol,
  BFGSTolerancef = poped.db$BFGSTolerancef,
  BFGSToleranceg = poped.db$BFGSToleranceg,
  BFGSTolerancex = poped.db$BFGSTolerancex,
  iter_tot = poped.db$iNumSearchIterationsIfNotLineSearch, iter_max = 10,
  ...)
}
\arguments{
\item{poped.db}{A PopED database.}

\item{ni}{A vector of the number of samples in each group.}

\item{xt}{A matrix of sample times.  Each row is a vector of sample times for a group.}

\item{model_switch}{A matrix that is the same size as xt, specifying which model each sample belongs to.}

\item{x}{A matrix for the discrete design variables.  Each row is a group.}

\item{a}{A matrix of covariates.  Each row is a group.}

\item{bpopdescr}{Matrix defining the fixed effects, per row (row number = parameter_number) we should have:
\itemize{
\item column 1 the type of the distribution for E-family designs (0 = Fixed, 1 = Normal, 2 = Uniform,
 3 = User Defined Distribution, 4 = lognormal and 5 = truncated normal)
\item column 2  defines the mean.
\item column 3 defines the variance of the distribution (or length of uniform distribution).
}}

\item{ddescr}{Matrix defining the diagnonals of the IIV (same logic as for the \code{bpopdescr}).}

\item{maxxt}{Matrix or single value defining the maximum value for each xt sample.  If a single value is
supplied then all xt values are given the same maximum value.}

\item{minxt}{Matrix or single value defining the minimum value for each xt sample.  If a single value is
supplied then all xt values are given the same minimum value}

\item{maxa}{Vector defining the max value for each covariate. IF a single value is supplied then
all a values are given the same max value}

\item{mina}{Vector defining the min value for each covariate. IF a single value is supplied then
all a values are given the same max value}

\item{fmf}{The initial value of the FIM. If set to zero then it is computed.}

\item{dmf}{The inital OFV. If set to zero then it is computed.}

\item{trflag}{Should the optimization be output to the screen and to a file?}

\item{bUseRandomSearch}{\itemize{
\item \bold{******START OF Optimization algorithm  SPECIFICATION OPTIONS**********}}
Use random search (1=TRUE, 0=FALSE)}

\item{bUseStochasticGradient}{Use Stochastic Gradient search (1=TRUE, 0=FALSE)}

\item{bUseBFGSMinimizer}{Use BFGS Minimizer (1=TRUE, 0=FALSE)}

\item{bUseLineSearch}{Use Line search (1=TRUE, 0=FALSE)}

\item{sgit}{Number of stochastic gradient iterations}

\item{ls_step_size}{Number of grid points in the line search}

\item{BFGSConvergenceCriteriaMinStep}{BFGS Minimizer Convergence Criteria Minimum Step}

\item{BFGSProjectedGradientTol}{BFGS Minimizer Convergence Criteria Normalized Projected Gradient Tolerance}

\item{BFGSTolerancef}{BFGS Minimizer Line Search Tolerance f}

\item{BFGSToleranceg}{BFGS Minimizer Line Search Tolerance g}

\item{BFGSTolerancex}{BFGS Minimizer Line Search Tolerance x}

\item{iter_tot}{Number of iterations to use if line search is not used. Must be less than \code{iter_max} to be used.}

\item{iter_max}{If line search is used then
the algorithm tests if line search (always run at the end of the optimization iteration) changes the
design in any way.  If not, the algorithm stops.  If yes, then a new iteration is run unless
\code{iter_max} iterations have already been run.}

\item{...}{arguments passed to \code{\link{evaluate.fim}} and \code{\link{ofv_fim}}.}
}
\description{
Optimize the objective function.
There are 4 different optimization algorithms used in this
function
\enumerate{
\item Adaptive random search. See \code{\link{RS_opt}}.
\item Stochastic gradient.
\item A Broyden Fletcher Goldfarb Shanno (BFGS)
method for nonlinear minimization with box constraints.
\item A line search. See \code{\link{a_line_search}}.
}
The optimization algorithms run in series, taking as input the output from the previous method.
The stopping rule used is to test if the line search algorithm fids a better optimum then its inital value.
If so, then the chain of algorithms is run again.  If line search is not used then the argument \code{iter_tot} defines the number of times the
chain of algorithms is run.
This function takes information from the PopED database supplied as an argument.
The PopED database supplies information about the the model, parameters, design and methods to use.
Some of the arguments coming from the PopED database can be overwritten;
if they are supplied then they are used instead of the arguments from the PopED database.
}
\examples{
## Warfarin example from software comparison in:
## Nyberg et al., "Methods and software tools for design evaluation 
##   for population pharmacokinetics-pharmacodynamics studies", 
##   Br. J. Clin. Pharm., 2014. 

## Optimization using an additive + proportional reidual error to 
##   avoid sample times at very low concentrations (time 0 or very late samoples).
library(PopED)

## find the parameters that are needed to define from the structural model
ff.PK.1.comp.oral.sd.CL

## -- parameter definition function 
## -- names match parameters in function ff
sfg <- function(x,a,bpop,b,bocc){
  parameters=c(CL=bpop[1]*exp(b[1]),
               V=bpop[2]*exp(b[2]),
               KA=bpop[3]*exp(b[3]),
               Favail=bpop[4],
               DOSE=a[1])
  return(parameters) 
}

## -- Define initial design  and design space
poped.db <- create.poped.database(ff_file="ff.PK.1.comp.oral.sd.CL",
                                  fg_file="sfg",
                                  fError_file="feps.add.prop",
                                  bpop=c(CL=0.15, V=8, KA=1.0, Favail=1), 
                                  notfixed_bpop=c(1,1,1,0),
                                  d=c(CL=0.07, V=0.02, KA=0.6), 
                                  sigma=c(0.01,0.25),
                                  groupsize=32,
                                  xt=c( 0.5,1,2,6,24,36,72,120),
                                  minxt=0,
                                  maxxt=120,
                                  a=70,
                                  mina=0,
                                  maxa=100)
# warfarin optimize model

\dontrun{
  
  ##############
  # typically one will use poped_optimize 
  # This then calls Doptim for continuous optimization problems
  ##############
  
  
  # RS+SG+LS optimization of sample times
  # optimization with just a few iterations
  # only to check that things are working
  output <- poped_optimize(poped.db,opt_xt=T,
                           rsit=5,sgit=5,ls_step_size=5)
  
  # RS+SG+LS optimization of sample times 
  # (longer run time than above but more likely to reach a maximum)
  output <- poped_optimize(poped.db,opt_xt=T)
  get_rse(output$fmf,output$poped.db)
  plot_model_prediction(output$poped.db)
  
  
  # Random search (just a few samples here)
  rs.output <- poped_optimize(poped.db,opt_xt=1,opt_a=1,rsit=20,
                              bUseRandomSearch= 1,
                              bUseStochasticGradient = 0,
                              bUseBFGSMinimizer = 0,
                              bUseLineSearch = 0)
  
  # line search, DOSE and sample time optimization
  ls.output <- poped_optimize(poped.db,opt_xt=1,opt_a=1,
                              bUseRandomSearch= 0,
                              bUseStochasticGradient = 0,
                              bUseBFGSMinimizer = 0,
                              bUseLineSearch = 1,
                              ls_step_size=10)
  
  # Stochastic gradient search, DOSE and sample time optimization
  sg.output <- poped_optimize(poped.db,opt_xt=1,opt_a=1, 
                              bUseRandomSearch= 0,
                              bUseStochasticGradient = 1,
                              bUseBFGSMinimizer = 0,
                              bUseLineSearch = 0,
                              sgit=20)
  
  # BFGS search, DOSE and sample time optimization
  bfgs.output <- poped_optimize(poped.db,opt_xt=1,opt_a=1,
                                bUseRandomSearch= 0,
                                bUseStochasticGradient = 0,
                                bUseBFGSMinimizer = 1,
                                bUseLineSearch = 0)

  ##############
  # If you really want to you can use Doptim dirtectly
  ##############
  dsl <- downsizing_general_design(poped.db)
  poped.db$optsw[2] <- 1  # sample time optimization
  output <- Doptim(poped.db,dsl$ni, dsl$xt, dsl$model_switch, dsl$x, dsl$a, 
         dsl$bpop, dsl$d, dsl$maxxt, dsl$minxt,dsl$maxa,dsl$mina) 
  
}


}
\references{
\enumerate{
\item M. Foracchia, A.C. Hooker, P. Vicini and A. Ruggeri, "PopED, a software for optimal
experimental design in population kinetics", Computer Methods and Programs in Biomedicine, 74, 2004.
\item J. Nyberg, S. Ueckert, E.A. Stroemberg, S. Hennig, M.O. Karlsson and A.C. Hooker, "PopED: An extended,
parallelized, nonlinear mixed effects models optimal design tool",
Computer Methods and Programs in Biomedicine, 108, 2012.
}
}
\seealso{
Other Optimize: \code{\link{LEDoptim}};
  \code{\link{RS_opt_gen}}; \code{\link{RS_opt}};
  \code{\link{a_line_search}}; \code{\link{bfgsb_min}};
  \code{\link{calc_autofocus}};
  \code{\link{calc_ofv_and_grad}}; \code{\link{mfea}};
  \code{\link{poped_optimize}}
}

