% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{import.freqtbl}
\alias{import.freqtbl}
\title{Load Merged Allele Frequency Table}
\usage{
import.freqtbl(freqtbl_filename)
}
\arguments{
\item{freqtbl_filename}{file containing the allele frequencies as an extended BED6+ file}
}
\value{
frequency table as bedgraph
}
\description{
This function accepts as input a path to a BED file containing allele frequency and returns a GRanges object ready for the freqShifter function.
}
\section{input format}{


This function accepts as input a path to a file in an extended BED6+ format; specifically,


`chrom start end name  score strand  reference_allele  alternate_allele  selected_parent_count selected_parent_allele_frequency  backcrossed_parent_count  backcrossed_parent_allele_frequency offspring_count offspring_allele_frequency`

eg,

 `chr2L	8517	8518	0	0	+	G	A	8	0	16	0.25	8	0.25`

Some of these fields (name, score, strand, reference_allele, alternate_allele, selected_parent_count, backcrossed_parent_count, offspring_count) are required as placeholders but not used in the current PopPsiSeq algorithm
This format is the output of joining and filtering the output of vcftools' --freq output; see vignette for details
}

\examples{
\donttest{
merged_frequencies.filename <- system.file("extdata",
"merged_frequencies.example_data.tbl", package = "PopPsiSeqR")
frequencies.bg <- import.freqtbl(merged_frequencies.filename)
}
}
