% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_weight_returns.R
\name{optim.Weight.Return}
\alias{optim.Weight.Return}
\title{Optimize portfolio weights given target returns and weights}
\usage{
optim.Weight.Return(
  asset.names,
  tgt.ret,
  rf = 0,
  max.wgt = 1,
  period = c("months", "weeks", "quarters", "years")
)
}
\arguments{
\item{asset.names}{Vector of ticker of securities}

\item{tgt.ret}{Target return for given funds}

\item{rf}{Risk-free rate of return, Default: 0}

\item{max.wgt}{Maximum weight to be allocated for one fund/security, Default: 1}

\item{period}{Period for which the returns are calculated, Default: c("months", "weeks", "quarters", "years")}
}
\value{
Returns a dataframe of the portfolios with different portfolio weights and different target returns and target standard deviation. Using this an investor can choose between range of portfolio to allocate funds.
}
\description{
Optimizes portfolio weights by minimizing the variance for a given target return and weights
}
\details{
Minimizes the variance using the method of lagrange multiplier to calculate the portfolio weights with minimized variance for given target return and given maximum weights.
}
\examples{
optim.Weight.Return(c('FXAIX', 'TIBFX'), period = 'weeks', max.wgt = 0.8, tgt.ret = 0.0015)
}
