/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.consumer;

import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.openfast.examples.Assert;
import org.openfast.examples.MessageBlockReaderFactory;
import org.openfast.examples.OpenFastExample;
import org.openfast.examples.consumer.FastMessageConsumer;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.multicast.MulticastClientEndpoint;
import org.openfast.session.tcp.TcpEndpoint;

public class Main
extends OpenFastExample {
    private static Options options = new Options();

    static {
        options.addOption("?", "help", false, "Displays this message");
        options.addOption("r", "protocol", true, "Protocol [tcp|udp] defaults to tcp");
        options.addOption("p", "port", true, "Port to connect to");
        options.addOption("h", "host", true, "The host name of the server (or group name for multicast)");
        options.addOption("i", "interface", true, "The ip address of the network interface to use");
        options.addOption("e", "error", false, "Show stacktrace information");
        options.addOption("t", "template", true, "Message template definition file");
        options.addOption("j", "readOffset", true, "The number of leading bytes that should be discarded when reading each message.");
        options.addOption("z", "variant", true, "Enable exchange-specific behavior.  Valid values: CME");
        options.addOption("d", "reset", false, "Enable reset of the encoder/decoder on every message.");
    }

    public static void main(String[] args) {
        CommandLine cl = Main.parseCommandLine("consumer", args, options);
        if (cl.hasOption("help")) {
            Main.displayHelp("consumer", options);
        }
        Endpoint endpoint = null;
        boolean showStacktrace = cl.hasOption("error");
        File templatesFile = null;
        try {
            String ifaddr;
            Assert.assertTrue(cl.hasOption("port"), "The required parameter \"port\" is missing.");
            int port = Main.getInteger(cl, "port");
            String host = cl.hasOption("host") ? cl.getOptionValue("host") : "localhost";
            String string = ifaddr = cl.hasOption("interface") ? cl.getOptionValue("interface") : null;
            if (Main.isMulticast(cl)) {
                endpoint = new MulticastClientEndpoint(port, host, ifaddr);
            }
            if (endpoint == null) {
                endpoint = new TcpEndpoint(host, port);
            }
            templatesFile = Main.getFile(cl, "template");
            Assert.assertTrue(templatesFile.exists(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" does not exist.");
            Assert.assertTrue(!templatesFile.isDirectory(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is a directory.");
            Assert.assertTrue(templatesFile.canRead(), "The template definition file \"" + templatesFile.getAbsolutePath() + "\" is not readable.");
        }
        catch (AssertionError e) {
            System.out.println(((Throwable)((Object)e)).getMessage());
            Main.displayHelp("consumer", options);
        }
        int readOffset = cl.hasOption("readOffset") ? Main.getInteger(cl, "readOffset") : 0;
        OpenFastExample.Variant variant = cl.hasOption("variant") ? Main.getVariant(cl) : OpenFastExample.Variant.DEFAULT;
        boolean shouldResetOnEveryMessage = cl.hasOption("reset") || OpenFastExample.Variant.CME == variant;
        MessageBlockReaderFactory msgBlockReaderFactory = new MessageBlockReaderFactory(variant, readOffset, Main.isMulticast(cl));
        FastMessageConsumer consumer = new FastMessageConsumer(endpoint, templatesFile, msgBlockReaderFactory, shouldResetOnEveryMessage);
        try {
            consumer.start();
        }
        catch (FastConnectionException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("Unable to connect to endpoint: " + e.getMessage());
            System.exit(1);
        }
        catch (IOException e) {
            if (showStacktrace) {
                e.printStackTrace();
            }
            System.out.println("An IO error occurred while consuming messages: " + e.getMessage());
            System.exit(1);
        }
    }
}

