/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.loader;

import java.util.List;
import java.util.Map;
import org.openfast.QName;
import org.openfast.error.ErrorHandler;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.FieldParser;
import org.w3c.dom.Element;

public class ParsingContext {
    static final ParsingContext NULL = new ParsingContext();
    private final ParsingContext parent;
    private String templateNamespace = null;
    private String namespace = null;
    private String dictionary = null;
    private ErrorHandler errorHandler;
    private TemplateRegistry templateRegistry;
    private Map typeMap;
    private List fieldParsers;
    private QName name;

    static {
        NULL.setDictionary("global");
        NULL.setNamespace("");
        NULL.setTemplateNamespace("");
    }

    public ParsingContext() {
        this(NULL);
    }

    public ParsingContext(ParsingContext parent) {
        this.parent = parent;
    }

    public ParsingContext(Element node, ParsingContext parent) {
        this.parent = parent;
        if (node.hasAttribute("templateNs")) {
            this.setTemplateNamespace(node.getAttribute("templateNs"));
        }
        if (node.hasAttribute("ns")) {
            this.setNamespace(node.getAttribute("ns"));
        }
        if (node.hasAttribute("dictionary")) {
            this.setDictionary(node.getAttribute("dictionary"));
        }
        if (node.hasAttribute("name")) {
            this.setName(new QName(node.getAttribute("name"), this.getNamespace()));
        }
    }

    private void setName(QName name) {
        this.name = name;
    }

    public void setTemplateNamespace(String templateNS) {
        this.templateNamespace = templateNS;
    }

    public String getTemplateNamespace() {
        if (this.templateNamespace == null) {
            return this.parent.getTemplateNamespace();
        }
        return this.templateNamespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        if (this.namespace == null) {
            return this.parent.getNamespace();
        }
        return this.namespace;
    }

    public void setDictionary(String dictionary) {
        this.dictionary = dictionary;
    }

    public String getDictionary() {
        if (this.dictionary == null) {
            return this.parent.getDictionary();
        }
        return this.dictionary;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ErrorHandler getErrorHandler() {
        if (this.errorHandler == null) {
            return this.parent.getErrorHandler();
        }
        return this.errorHandler;
    }

    public TemplateRegistry getTemplateRegistry() {
        if (this.templateRegistry == null) {
            return this.parent.getTemplateRegistry();
        }
        return this.templateRegistry;
    }

    public void setTemplateRegistry(TemplateRegistry templateRegistry) {
        this.templateRegistry = templateRegistry;
    }

    public void setTypeMap(Map typeMap) {
        this.typeMap = typeMap;
    }

    public Map getTypeMap() {
        if (this.typeMap == null) {
            return this.parent.getTypeMap();
        }
        return this.typeMap;
    }

    public List getFieldParsers() {
        if (this.fieldParsers == null) {
            return this.parent.getFieldParsers();
        }
        return this.fieldParsers;
    }

    public void setFieldParsers(List list) {
        this.fieldParsers = list;
    }

    public FieldParser getFieldParser(Element element) {
        List parsers = this.getFieldParsers();
        int i = parsers.size() - 1;
        while (i >= 0) {
            FieldParser fieldParser = (FieldParser)parsers.get(i);
            if (fieldParser.canParse(element, this)) {
                return fieldParser;
            }
            --i;
        }
        return null;
    }

    public ParsingContext getParent() {
        return this.parent;
    }

    public QName getName() {
        return this.name;
    }

    public void addFieldParser(FieldParser parser) {
        this.getFieldParsers().add(parser);
    }
}

