/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.debug;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.openfast.ByteUtil;
import org.openfast.FieldValue;
import org.openfast.debug.Trace;
import org.openfast.template.Field;
import org.openfast.template.Group;

public class BasicEncodeTrace
implements Trace {
    private Stack stack = new Stack();
    private PrintWriter out = new PrintWriter(System.out);

    public void groupStart(Group group) {
        TraceGroup traceGroup = new TraceGroup(group);
        if (!this.stack.isEmpty()) {
            ((TraceGroup)this.stack.peek()).addGroup(traceGroup);
        }
        this.stack.push(traceGroup);
    }

    public void field(Field field, FieldValue value, FieldValue encoded, byte[] encoding, int pmapIndex) {
        ((TraceGroup)this.stack.peek()).addField(field, value, encoded, pmapIndex, encoding);
    }

    public void groupEnd() {
        TraceGroup group = (TraceGroup)this.stack.pop();
        if (this.stack.isEmpty()) {
            this.out.println(group);
        }
    }

    public void pmap(byte[] pmap) {
        ((TraceGroup)this.stack.peek()).setPmap(pmap);
    }

    public String indent(int indent) {
        String tab = "";
        int i = 0;
        while (i < indent) {
            tab = String.valueOf(tab) + " ";
            ++i;
        }
        return tab;
    }

    public void setWriter(PrintWriter traceWriter) {
        this.out = traceWriter;
    }

    private class TraceField
    implements TraceNode {
        private Field field;
        private int pmapIndex;
        private byte[] encoding;
        private FieldValue value;
        private FieldValue encoded;

        public TraceField(Field field, FieldValue value, FieldValue encoded, int pmapIndex, byte[] encoding) {
            this.field = field;
            this.value = value;
            this.encoded = encoded;
            this.pmapIndex = pmapIndex;
            this.encoding = encoding;
        }

        public StringBuilder serialize(StringBuilder builder, int indent) {
            builder.append(BasicEncodeTrace.this.indent(indent));
            builder.append(this.field.getName()).append("[");
            if (this.field.usesPresenceMapBit()) {
                builder.append("pmapIndex:").append(this.pmapIndex);
            }
            builder.append("]: ").append(this.value).append(" = ").append(this.encoded).append(" -> ");
            builder.append(ByteUtil.convertByteArrayToBitString(this.encoding));
            builder.append("\n");
            return builder;
        }
    }

    private class TraceGroup
    implements TraceNode {
        private List nodes;
        private byte[] pmap;
        private Group group;

        public TraceGroup(Group group) {
            this.group = group;
            this.nodes = new ArrayList(group.getFieldCount());
        }

        public void setPmap(byte[] pmap) {
            this.pmap = pmap;
        }

        public void addField(Field field, FieldValue value, FieldValue encoded, int fieldIndex, byte[] encoding) {
            this.nodes.add(new TraceField(field, value, encoded, fieldIndex, encoding));
        }

        public void addGroup(TraceGroup traceGroup) {
            this.nodes.add(traceGroup);
        }

        public StringBuilder serialize(StringBuilder builder, int indent) {
            builder.append(BasicEncodeTrace.this.indent(indent)).append(this.group.getName()).append("\n");
            indent += 2;
            if (this.pmap != null) {
                builder.append(BasicEncodeTrace.this.indent(indent)).append("PMAP: ").append(ByteUtil.convertByteArrayToBitString(this.pmap)).append("\n");
            }
            int i = 0;
            while (i < this.nodes.size()) {
                ((TraceNode)this.nodes.get(i)).serialize(builder, indent);
                ++i;
            }
            indent -= 2;
            return builder;
        }

        public String toString() {
            return this.serialize(new StringBuilder(), 0).toString();
        }
    }

    private static interface TraceNode {
        public StringBuilder serialize(StringBuilder var1, int var2);
    }
}

