/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.message.CalculationStatusMessage;
import com.portfolioeffect.quant.client.message.ClientMessage;
import com.portfolioeffect.quant.client.message.LogoutResponse;
import com.portfolioeffect.quant.client.message.Reject;
import com.portfolioeffect.quant.client.message.ServiceMessage;
import com.portfolioeffect.quant.client.message.TestRequest;
import com.portfolioeffect.quant.client.message.TransmitDataListMessage;
import com.portfolioeffect.quant.client.message.TransmitDataRequest;
import com.portfolioeffect.quant.client.message.TransmitDataResponse;
import com.portfolioeffect.quant.client.message.ValidationResponse;
import com.portfolioeffect.quant.client.message.type.EncryptMethodType;
import com.portfolioeffect.quant.client.message.type.EncryptedPasswordMethodType;
import com.portfolioeffect.quant.client.message.type.FastMessageType;
import com.portfolioeffect.quant.client.message.util.ClientRequestMessageFactory;
import com.portfolioeffect.quant.client.message.util.CryptograhicUtils;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageFactory;
import com.portfolioeffect.quant.client.message.util.ServerResponseMessageParser;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.model.PriceDataSet;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import com.portfolioeffect.quant.client.util.MetricRefreshValue;
import com.portfolioeffect.quant.client.util.MetricUpdateCallback;
import com.portfolioeffect.quant.client.util.ProgressBar;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import com.portfolioeffect.quant.client.util.StopWatch;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.SerializationUtils;
import org.iq80.snappy.Snappy;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.MessageInputStream;
import org.openfast.MessageOutputStream;
import org.openfast.error.FastException;
import org.openfast.examples.MessageBlockReaderFactory;
import org.openfast.examples.MessageBlockWriterFactory;
import org.openfast.examples.OpenFastExample;
import org.openfast.session.Connection;
import org.openfast.session.Endpoint;
import org.openfast.session.FastConnectionException;
import org.openfast.session.tcp.TcpEndpoint;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class ClientConnection {
    private static final int MILLISEC_IN_SECOND = 1000;
    public static final String STREAM_IS_ALREADY_RUNNING = "Stream is already running";
    private static final int TIME_WAIT_TOPRINT = 30;
    private static final String SUPPORTED_CHARSET = "US-ASCII";
    private static final int TEST_PORT_NUMBER = 3443;
    private static final int MAX_BLOCK_DIMENSION = 100000;
    private static final int USER_LAYER_TIMEOUT_SECONDS_ESTIMATE = 300;
    private static final int DATA_TRANSMIT_TIMEOUT_SECONDS_ESTIMATE = 300;
    private static final int LOGON_TIMEOUT_SECONDS = 30;
    private static final int SERVICE_TIMEOUT_SEC = 30;
    private static final int PORT_NUMBER = 443;
    private static final String TEMPLATES_FILE = "config/template-quant.xml";
    private static final int LOGON_ATTEMPT_COUNT = 9;
    private static final int DEFAULT_LOGON_TIMEOUT_SEC = 30;
    private static final int HEARTBEAT_INTERVAL = 30;
    private static final EncryptMethodType ENCRYPT_METHOD_TYPE = EncryptMethodType.NONE;
    private static final int RESTART_TIME_WAIT = 600;
    private AtomicBoolean isStreamEnabled = new AtomicBoolean(false);
    private AtomicBoolean isStreamRuning = new AtomicBoolean(false);
    private String apiKey;
    private String username;
    private String password;
    private String templatesFileName;
    private String host;
    private int port;
    private Connection connection;
    private MessageOutputStream out;
    private MessageInputStream in;
    private MessageBlockWriterFactory messageBlockWriterFactory;
    private MessageBlockReaderFactory messageBlockReaderFactory;
    private volatile boolean isLoggedOn = false;
    private volatile boolean isConnected = false;
    private boolean isMessageLoggingEnabled = true;
    private Thread inboundMessageRouter;
    private Endpoint endpoint;
    private TemplateRegistry templateRegistry;
    private int outboundMsgSeqNum;
    private int indicatorDefRequestNum;
    private volatile LinkedBlockingDeque<ClientMessage> clientMessageQueue;
    private volatile LinkedBlockingDeque<ServiceMessage> serviceMessageQueue;
    private StopWatch timeDataFast = new StopWatch();
    private StopWatch timeDataTransmit = new StopWatch();
    private boolean debugModeEnabled = false;
    private StringBuffer callStatus = new StringBuffer();
    private int groupSize = 1;
    private int progressBarI = 0;
    private int progressBarMax = 0;
    private Thread heartbeatMonitor;
    private ProgressBar progressBar = new ProgressBar();
    private MetricUpdateCallback streamRefreshCallback = null;
    private SimpleMetricUpdateCallback streamRefreshCallbackPureData = null;
    private long idClient;
    private static AtomicLong idClientGenerator;
    private static AtomicLong id;
    private List<String> batchMetricKeys = null;

    static {
        id = new AtomicLong();
        idClientGenerator = new AtomicLong();
    }

    public static long getNewId() {
        return id.incrementAndGet();
    }

    public long getIdClient() {
        return this.idClient;
    }

    public ClientConnection() {
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        this.setPort(443);
        this.idClient = idClientGenerator.getAndIncrement();
    }

    public long getIdC() {
        return this.idClient;
    }

    public void start() throws IOException, FastConnectionException {
        this.endpoint = new TcpEndpoint(this.host, this.port);
        XMLMessageTemplateLoader loader = new XMLMessageTemplateLoader();
        loader.setLoadTemplateIdFromAuxId(true);
        loader.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.templatesFileName));
        this.templateRegistry = loader.getTemplateRegistry();
        Context context = new Context();
        context.setTemplateRegistry(this.templateRegistry);
        this.messageBlockWriterFactory = new MessageBlockWriterFactory(OpenFastExample.Variant.DEFAULT, 0, false);
        this.messageBlockReaderFactory = new MessageBlockReaderFactory(OpenFastExample.Variant.DEFAULT, 0, false);
        this.connection = this.endpoint.connect();
        this.in = new MessageInputStream(this.connection.getInputStream(), context);
        this.in.setBlockReader(this.messageBlockReaderFactory.create());
        this.out = new MessageOutputStream(this.connection.getOutputStream(), context);
        this.out.setBlockWriter(this.messageBlockWriterFactory.create());
        this.isConnected = true;
        this.clientMessageQueue = new LinkedBlockingDeque();
        this.serviceMessageQueue = new LinkedBlockingDeque();
        this.inboundMessageRouter = new Thread(new InboundMessageWorker());
        this.inboundMessageRouter.start();
        this.heartbeatMonitor = new Thread(new HeartbeatMonitor());
        this.heartbeatMonitor.start();
    }

    public void stop() {
        if (this.isConnected) {
            try {
                if (this.isLoggedOn()) {
                    this.logout(30);
                }
                this.endpoint.close();
                this.connection.close();
                this.inboundMessageRouter.join();
                this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis(), true));
                this.heartbeatMonitor.interrupt();
            }
            catch (Exception e) {
                throw new RuntimeException("Error while stoping client.", e);
            }
            this.isConnected = false;
        }
    }

    public void logout() {
        if (this.isConnected && this.isLoggedOn()) {
            Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            this.out.writeMessage(logoutMsg);
        }
    }

    public void logon() {
        try {
            this.logon(30);
        }
        catch (Exception e) {
            this.stop();
        }
    }

    public void logon(int timeoutSec) throws Exception {
        this.logon(timeoutSec, 0);
    }

    public boolean logon(int timeoutSec, int attemptCount) throws Exception {
        if (attemptCount > 9) {
            return false;
        }
        String encryptedPassword = CryptograhicUtils.encrypt(this.password, this.apiKey);
        Message loginMsg = ClientRequestMessageFactory.createLogonRequest(this.templateRegistry, 30, ENCRYPT_METHOD_TYPE, this.username, encryptedPassword, EncryptedPasswordMethodType.AES, encryptedPassword.length(), this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message msg = this.sendAndAwaitResponse(loginMsg, timeoutSec);
        FastMessageType responseMessageType = this.getMessageType(msg);
        String curentHost = this.getHost();
        int curentPort = this.getPort();
        if (responseMessageType == FastMessageType.LOGOUT) {
            LogoutResponse logoutReponse = ServerResponseMessageParser.parseLogoutResponse(msg);
            throw new Exception(logoutReponse.getText());
        }
        this.setHost(curentHost);
        this.setPort(curentPort);
        if (attemptCount == 0 && !this.isLoggedOn()) {
            throw new ConnectFailedException();
        }
        return this.isLoggedOn;
    }

    public void logout(int timeoutSec) {
        if (!this.isLoggedOn()) {
            return;
        }
        Message logoutMsg = ClientRequestMessageFactory.createLogoutRequest(this.templateRegistry, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        try {
            this.sendAndAwaitResponse(logoutMsg, timeoutSec);
        }
        catch (Exception e) {
            this.isLoggedOn = false;
        }
    }

    public void progressBarIAdd(int value) {
        if (this.progressBarMax == 0) {
            this.progressBarMax = value * this.groupSize;
            this.progressBarI = 0;
        }
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        this.progressBarI += value;
        this.progressBar.printCompletionStatus(this.progressBarI, this.progressBarMax);
        if (this.progressBarI == this.progressBarMax) {
            this.createCallGroup(1);
        }
    }

    public void createCallGroup(int groupSize) {
        this.groupSize = groupSize;
        this.progressBarI = 0;
        this.progressBarMax = 0;
        this.progressBar.reset();
        this.progressBar.setScale(groupSize);
    }

    public void printProgressBar(double percent) {
        this.progressBar.printCompletionStatus(percent);
    }

    public void proggressBarOn() {
        this.progressBar.setON(true);
    }

    public void proggressBarOff() {
        this.progressBar.setON(false);
    }

    public void resetProgressBar() {
        this.progressBar.reset();
    }

    public void setHost(String host) {
        this.host = host;
        if (host.equals("localhost")) {
            this.setPort(3443);
        } else {
            this.setPort(443);
        }
    }

    public Metric start(String username, String password, String apiKey, String remoteHostName) {
        this.clearStatus();
        this.stop();
        this.setMessageLoggingEnabled(false);
        this.setTemplatesFileName(TEMPLATES_FILE);
        if (remoteHostName.equals("localhost")) {
            this.setPort(3443);
        } else {
            this.setPort(443);
        }
        this.setUsername(username);
        this.setPassword(password);
        this.setApiKey(apiKey);
        this.setHost(remoteHostName);
        try {
            this.start();
        }
        catch (Exception e) {
            this.stop();
            return new Metric("Cannot connect to server. Check remote host address and your firewall rules.");
        }
        try {
            this.logon(30);
        }
        catch (Exception e) {
            this.stop();
            if (e.getMessage().contains(":")) {
                return new Metric(e.getMessage().split(":")[1]);
            }
            return new Metric(e.getMessage());
        }
        return new Metric();
    }

    private void clearStatus() {
        this.callStatus.setLength(0);
    }

    public Metric restart() {
        int totalTime = 0;
        int waitTime = -1;
        while (totalTime < 600) {
            ++waitTime;
            this.stop();
            try {
                if (waitTime >= 1) {
                    if ((totalTime += waitTime) > 30) {
                        Console.write("\nConnecting to  server.");
                    }
                    this.waitAndDots(waitTime, totalTime);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.clearStatus();
            try {
                this.start();
                this.logon(30);
            }
            catch (IOException e) {
                continue;
            }
            catch (FastConnectionException e) {
                continue;
            }
            catch (ConnectFailedException e) {
                continue;
            }
            catch (Exception e) {
                this.stop();
                return new Metric(e.getMessage());
            }
            if (!this.isLoggedOn()) continue;
            if (totalTime > 30) {
                Console.writeln(".OK.");
            }
            return new Metric();
        }
        if (!this.isLoggedOn()) {
            return new Metric("Cannot connect to server. Check remote host address and your firewall rules.");
        }
        return new Metric();
    }

    private void waitAndDots(int sec, int totalTime) throws InterruptedException {
        if (totalTime > 30) {
            Console.write(".");
        }
        Thread.sleep(sec * 1000);
    }

    public double getDataVolume(double[] price, int[] timeSec) {
        PriceDataSet data;
        try {
            data = new PriceDataSet(price, timeSec);
        }
        catch (Exception e) {
            return 0.0;
        }
        double a = data.toBinaryZipCompress().length;
        return a / 1024.0 / 1024.0;
    }

    public double getDataVolume(double[] price) {
        return this.getDataVolume(price, new int[0]);
    }

    public static boolean isPureAscii(String v) {
        CharsetEncoder asciiEncoder = Charset.forName(SUPPORTED_CHARSET).newEncoder();
        return asciiEncoder.canEncode(v);
    }

    public Metric validateStringRequest(String requestString) throws Exception {
        if (this.isStreamEnabled.get()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        if (!ClientConnection.isPureAscii(requestString)) {
            return new Metric("Request String contains a non-ASCII character.");
        }
        String[] paramList = new String[]{};
        Message msg = ClientRequestMessageFactory.createValidationRequest(this.getTemplateRegistry(), requestString, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        ValidationResponse response = ServerResponseMessageParser.parseValidationResponse(responseMsg);
        if (!response.getMsgType().equals("OK")) {
            return new Metric(response.getMsgBody());
        }
        Type mapType = new TypeToken<String[]>(){}.getType();
        Gson gson = new Gson();
        paramList = (String[])gson.fromJson(response.getMsgBody(), mapType);
        Metric result = new Metric();
        ArrayCache pL = new ArrayCache(paramList);
        result.setData("positions", pL);
        return result;
    }

    public Metric transmitQuantity(String assetName, int[] dataInt, long[] time) throws Exception {
        if (this.isStreamEnabled.get()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        boolean isFirstBlock = true;
        int position = 0;
        int i = 0;
        while (i < time.length / 100000) {
            int[] dataTransmit = new int[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
            ++i;
        }
        if (time.length % 100000 != 0) {
            int[] dataTransmit = new int[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataInt, position, dataTransmit, 0, dataInt.length % 100000);
            String type = "QUANTITY";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        Metric result = new Metric();
        result.setMessage("NON");
        return result;
    }

    public boolean transmitStreamQuantity(String assetName, int quantity, long time) throws Exception {
        if (!this.isStreamRuning.get()) {
            return false;
        }
        int[] dataTransmit = new int[]{quantity};
        long[] timeTransmit = new long[]{time};
        String type = "QUANTITY:stream";
        String request = assetName;
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        this.send(msg);
        return true;
    }

    public Metric transmitUserPrice(String assetName, float[] dataFloat, long[] time) throws Exception {
        if (this.isStreamEnabled.get()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        boolean isFirstBlock = true;
        int position = 0;
        int i = 0;
        while (i < time.length / 100000) {
            float[] dataTransmit = new float[100000];
            long[] timeTransmit = new long[100000];
            System.arraycopy(time, position, timeTransmit, 0, 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            position += 100000;
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
            ++i;
        }
        if (time.length % 100000 != 0) {
            float[] dataTransmit = new float[time.length % 100000];
            long[] timeTransmit = new long[time.length % 100000];
            System.arraycopy(time, position, timeTransmit, 0, time.length % 100000);
            System.arraycopy(dataFloat, position, dataTransmit, 0, time.length % 100000);
            String type = "USER_PRICE";
            if (!isFirstBlock) {
                type = String.valueOf(type) + ":+";
            } else {
                isFirstBlock = false;
            }
            String request = assetName;
            Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), type, request, dataTransmit, timeTransmit, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
            Message responseMsg = this.sendAndAwaitResponse(msg, 300);
            TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
            if (!response.getMsgType().equals("OK")) {
                throw new Exception(response.getMsgBody());
            }
        }
        Metric result = new Metric();
        result.setMessage("NON");
        return result;
    }

    public Metric transmitDataList(String fromTime, String toTime, ArrayList<String> dataList, String windowLength, String priceSamplingInterval, String momentsModel, String trainingPeriodEnabled) throws Exception {
        if (this.isStreamEnabled.get()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        for (String e : dataList) {
            if (ClientConnection.isPureAscii(e)) continue;
            return new Metric("Position name String contains a non-ASCII character.");
        }
        this.timeDataFast.reset();
        this.timeDataTransmit.reset();
        String requestType = "CHECK_DATA";
        TransmitDataListMessage dataListMessage = new TransmitDataListMessage(dataList, windowLength, fromTime, toTime, priceSamplingInterval, momentsModel, trainingPeriodEnabled);
        Gson gson = new Gson();
        Type mapType = new TypeToken<TransmitDataListMessage>(){}.getType();
        String request = gson.toJson((Object)dataListMessage, mapType);
        this.timeDataFast.start();
        Message msg = ServerResponseMessageFactory.createTransmitDataRequest(this.getTemplateRegistry(), requestType, request, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        this.timeDataFast.stop();
        this.timeDataTransmit.start();
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        this.timeDataTransmit.stop();
        this.timeDataFast.start();
        TransmitDataResponse response = ServerResponseMessageParser.parseTransmitDataResponse(responseMsg);
        this.timeDataFast.stop();
        if (response.getMsgType().equals("OK")) {
            Metric result = new Metric();
            result.setMessage(response.getMsgBody());
            return result;
        }
        return new Metric(response.getMsgBody());
    }

    public Metric estimateEstimator(String metricType) throws Exception {
        if (this.isStreamEnabled.get()) {
            return new Metric(STREAM_IS_ALREADY_RUNNING);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        ArrayCache resultValueList = null;
        ArrayCache resultTimeList = null;
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        this.progressBar.printCompletionStatus(percent);
        while (isRun) {
            Message responseMsg;
            Message msg;
            this.clearStatus();
            if (isFirstBlock) {
                resultValueList = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
                resultTimeList = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), metricType, "", new double[1], new int[1], this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
                isFirstBlock = false;
            } else {
                msg = ClientRequestMessageFactory.createNonparametricComputeRequest(this.getTemplateRegistry(), metricType, "#NEXT#", new double[1], new int[1], this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                resultValueList.writeAsDouble(data);
                resultTimeList.write(time);
                percent = Double.valueOf(response.getMsgBody());
                this.progressBar.printCompletionStatus(percent);
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            throw new Exception(response.getMsgBody());
        }
        if (dimensions != null) {
            resultValueList.setDimensions(dimensions);
        }
        Metric result = new Metric();
        result.setData("value", resultValueList);
        result.setData("time", resultTimeList);
        result.setInfo(info);
        return result;
    }

    public void stopStream() {
        this.isStreamEnabled.set(false);
        this.stop();
        this.batchMetricKeys = null;
    }

    public List<String> getBatchMetricKeys() {
        return this.batchMetricKeys;
    }

    public void setBatchMetricKeys(List<String> batchMetricKeys, long portfolioID) {
        this.batchMetricKeys = new ArrayList<String>();
        for (String e : batchMetricKeys) {
            if (e.charAt(0) == '{' && e.length() > 1) {
                this.batchMetricKeys.add("{portfolioID:" + portfolioID + ", request:" + e);
                continue;
            }
            this.batchMetricKeys.add(e);
        }
    }

    public Metric estimateTransactional(String metricType, String indexPosition, ArrayList<String> positionList, String params) throws Exception {
        if (metricType.contains("stream")) {
            if (this.isStreamEnabled.get()) {
                return new Metric(STREAM_IS_ALREADY_RUNNING);
            }
            this.isStreamEnabled.set(true);
        }
        HashMap<String, String> info = new HashMap<String, String>();
        boolean isRun = true;
        boolean isFirstBlock = true;
        double percent = 0.0;
        int[] dimensions = null;
        this.progressBar.printCompletionStatus(percent);
        ArrayCache[] batchValues = null;
        ArrayCache[] batchValuesTime = null;
        while (isRun) {
            Message responseMsg;
            this.clearStatus();
            if (isFirstBlock) {
                if (indexPosition.length() != 0) {
                    positionList.add(0, indexPosition);
                }
                Gson gson = new Gson();
                String request = gson.toJson(positionList);
                if (this.debugModeEnabled) {
                    Console.writeln("Request--->");
                    Console.writeln(metricType);
                    Console.writeln(request);
                    Console.writeln(params);
                    Console.writeln(">---");
                }
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), metricType, request, params, this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
            } else {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), metricType, "#NEXT#", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                responseMsg = this.sendAndAwaitResponse(msg, 300);
            }
            TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
            if (response.getMsgType().contains("OK")) {
                int m;
                int k;
                int len;
                int k2;
                Gson gson = new Gson();
                Type mapType = new TypeToken<CalculationStatusMessage>(){}.getType();
                CalculationStatusMessage statusMessg = (CalculationStatusMessage)gson.fromJson(response.getMsgType(), mapType);
                dimensions = statusMessg.getDimension();
                if (dimensions.length == 0) {
                    dimensions = new int[]{1};
                }
                float[] data = response.getDataFloat();
                long[] time = response.getTime();
                if (this.debugModeEnabled) {
                    if (data.length > 0) {
                        Console.writeln("RECEIVED DATA BLOCK(" + data.length + "): " + data[0] + "\t" + data[data.length - 1]);
                    }
                    if (time.length > 0) {
                        Console.writeln("RECEIVED TIME BLOCK(" + time.length + "): " + new Timestamp(time[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(time[time.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
                    }
                }
                if (isFirstBlock) {
                    batchValues = new ArrayCache[dimensions.length];
                    int i = 0;
                    while (i < dimensions.length) {
                        batchValues[i] = dimensions[i] == 1 ? new ArrayCache(ArrayCacheType.DOUBLE_VECTOR) : new ArrayCache(ArrayCacheType.DOUBLE_MATRIX);
                        batchValues[i].setDimensions(new int[]{dimensions[i]});
                        ++i;
                    }
                    batchValuesTime = new ArrayCache[batchValues.length];
                    k2 = 0;
                    while (k2 < batchValues.length) {
                        batchValuesTime[k2] = new ArrayCache(ArrayCacheType.LONG_VECTOR);
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < batchValues.length) {
                        batchValuesTime[k2].lockToWrite();
                        batchValues[k2].lockToWrite();
                        ++k2;
                    }
                    len = 0;
                    while (len < data.length) {
                        k = 0;
                        while (k < dimensions.length) {
                            m = 0;
                            while (m < dimensions[k]) {
                                batchValues[k].writeNextDouble(data[len]);
                                ++len;
                                ++m;
                            }
                            ++k;
                        }
                    }
                    k = 0;
                    while (k < batchValues.length) {
                        batchValuesTime[k].writeNextLong(time);
                        ++k;
                    }
                    k = 0;
                    while (k < batchValues.length) {
                        batchValuesTime[k].unlockToWrite();
                        batchValues[k].unlockToWrite();
                        ++k;
                    }
                    isFirstBlock = false;
                } else {
                    k2 = 0;
                    while (k2 < batchValues.length) {
                        batchValuesTime[k2].lockToWrite();
                        batchValues[k2].lockToWrite();
                        ++k2;
                    }
                    k2 = 0;
                    while (k2 < batchValues.length) {
                        batchValuesTime[k2].writeNextLong(time);
                        ++k2;
                    }
                    len = 0;
                    while (len < data.length) {
                        k = 0;
                        while (k < dimensions.length) {
                            m = 0;
                            while (m < dimensions[k]) {
                                batchValues[k].writeNextDouble(data[len]);
                                ++len;
                                ++m;
                            }
                            ++k;
                        }
                    }
                    k = 0;
                    while (k < batchValues.length) {
                        batchValuesTime[k].unlockToWrite();
                        batchValues[k].unlockToWrite();
                        ++k;
                    }
                }
                percent = Double.valueOf(response.getMsgBody());
                this.progressBar.printCompletionStatus(percent);
                if (this.isStreamEnabled.get() && percent >= 1.0) {
                    StreamWoker streamWoker = new StreamWoker(batchValues, batchValuesTime, dimensions, this.streamRefreshCallback, this.streamRefreshCallbackPureData);
                    new Thread(streamWoker).start();
                    info = statusMessg.getResultInfo();
                    isRun = false;
                }
                if (!response.getMsgType().contains("STOP")) continue;
                info = statusMessg.getResultInfo();
                isRun = false;
                continue;
            }
            this.isStreamEnabled.set(false);
            throw new Exception(response.getMsgBody());
        }
        Metric result = new Metric();
        result.setData("values", batchValues);
        result.setData("times", batchValuesTime);
        result.setInfo(info);
        return result;
    }

    public Metric getAllSymbolsList() throws Exception {
        Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), "ALL_SYMBOLS", "", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
        Message responseMsg = this.sendAndAwaitResponse(msg, 300);
        TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
        Metric result = new Metric();
        if (!response.getMsgType().contains("OK")) {
            throw new Exception(response.getMsgBody());
        }
        byte[] data = response.getDataFloatByte();
        data = Snappy.uncompress((byte[])data, (int)0, (int)data.length);
        Map map = (Map)SerializationUtils.deserialize((byte[])data);
        ArrayCache id = new ArrayCache((String[])map.get("id"));
        ArrayCache description = new ArrayCache((String[])map.get("description"));
        ArrayCache exchange = new ArrayCache((String[])map.get("exchange"));
        result.setData("id", id);
        result.setData("description", description);
        result.setData("exchange", exchange);
        return result;
    }

    public Metric getComputeTimeLeft() {
        int i = 0;
        while (i < 3) {
            try {
                Message msg = ClientRequestMessageFactory.createTransactionalPortfolioComputeRequest(this.getTemplateRegistry(), "TIME_LEFT", "", "", this.getOutboundMsgSequenceNumber(), System.currentTimeMillis());
                Message responseMsg = this.sendAndAwaitResponse(msg, 300);
                TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
                Metric result = new Metric();
                if (!response.getMsgType().contains("OK")) {
                    throw new Exception(response.getMsgBody());
                }
                String[] data = response.getMsgBody().split("#");
                HashMap<String, String> info = new HashMap<String, String>();
                info.put("timeLeft", data[0]);
                info.put("timeMax", data[1]);
                result.setInfo(info);
                return result;
            }
            catch (Exception e) {
                Metric result = this.processException(e);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return new Metric("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    private Metric processException(Exception e) {
        if (e instanceof ConnectFailedException) {
            Metric isRestarted = this.restart();
            if (isRestarted.hasError()) {
                this.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            Metric isRestarted = this.restart();
            if (isRestarted.hasError()) {
                this.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return null;
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new Metric("Unknown error.");
        }
        this.resetProgressBar();
        return new Metric(e.getMessage());
    }

    private Message sendAndAwaitResponse(Message request, int timeoutSec) throws Exception {
        if (!this.isConnected) {
            throw new ConnectFailedException();
        }
        try {
            this.out.writeMessage(request);
        }
        catch (Exception e) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.poll(timeoutSec, TimeUnit.SECONDS);
        this.clientMessageQueue.clear();
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage == null || clientMessage.isEmpty()) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    public void send(Message request) throws Exception {
        if (!this.isConnected) {
            throw new ConnectFailedException();
        }
        try {
            this.out.writeMessage(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ConnectFailedException("Error writing to stream");
        }
    }

    public Message awaitResponse() throws Exception {
        if (!this.isConnected) {
            throw new ConnectFailedException();
        }
        ClientMessage clientMessage = this.clientMessageQueue.poll(200L, TimeUnit.DAYS);
        this.clientMessageQueue.clear();
        if (clientMessage == null) {
            throw new ConnectFailedException();
        }
        if (clientMessage == null || clientMessage.isEmpty()) {
            throw new ConnectFailedException();
        }
        if (clientMessage.isRejected()) {
            Reject reject = ServerResponseMessageParser.parseReject(clientMessage.getMessage());
            throw new Exception(reject.getText());
        }
        return clientMessage.getMessage();
    }

    private void sendHeartbeat(String testReqId) {
        Message logoutMsg = ClientRequestMessageFactory.createHeartbeat(this.templateRegistry, this.nextOutboundMsgSequenceNumber(), testReqId);
        this.out.writeMessage(logoutMsg);
    }

    public TemplateRegistry getTemplateRegistry() throws Exception {
        if (this.templateRegistry == null) {
            throw new ConnectFailedException();
        }
        return this.templateRegistry;
    }

    private FastMessageType getMessageType(Message msg) {
        String msgTypeCode = msg.getString("MessageType");
        FastMessageType fastMsgType = FastMessageType.getFastMessageType(msgTypeCode);
        return fastMsgType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTemplatesFileName() {
        return this.templatesFileName;
    }

    public void setTemplatesFileName(String templatesFileName) {
        this.templatesFileName = templatesFileName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setMessageLoggingEnabled(boolean isMessageLoggingEnabled) {
        this.isMessageLoggingEnabled = isMessageLoggingEnabled;
    }

    public boolean isMessageLoggingEnabled() {
        return this.isMessageLoggingEnabled;
    }

    public boolean isLoggedOn() {
        return this.isLoggedOn;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public int nextOutboundMsgSequenceNumber() {
        return this.outboundMsgSeqNum++;
    }

    public int getOutboundMsgSequenceNumber() {
        return this.outboundMsgSeqNum++;
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeEnabled;
    }

    public void setDebugModeEnabled(boolean debugModeEnabled) {
        this.debugModeEnabled = debugModeEnabled;
    }

    public String getStatus() {
        return this.callStatus.toString();
    }

    protected void finalize() throws Throwable {
        this.stop();
        super.finalize();
    }

    public void setStreamRefreshCallback(MetricUpdateCallback streamRefreshCallback) {
        this.streamRefreshCallback = streamRefreshCallback;
    }

    public SimpleMetricUpdateCallback getStreamRefreshCallbackPureData() {
        return this.streamRefreshCallbackPureData;
    }

    public void setStreamRefreshCallbackPureData(SimpleMetricUpdateCallback streamRefreshCallbackPureData) {
        this.streamRefreshCallbackPureData = streamRefreshCallbackPureData;
    }

    public AtomicBoolean isStreamEnabled() {
        return this.isStreamEnabled;
    }

    private class HeartbeatMonitor
    implements Runnable {
        private HeartbeatMonitor() {
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    ServiceMessage serviceMessage = (ServiceMessage)ClientConnection.this.serviceMessageQueue.poll(30L, TimeUnit.SECONDS);
                    if (serviceMessage == null) {
                        ClientConnection.this.clientMessageQueue.offer(new ClientMessage(null, false, true));
                        continue;
                    }
                    if (!serviceMessage.isTerminated()) continue;
                }
                catch (Exception e) {}
                break;
            }
        }
    }

    private class InboundMessageWorker
    implements Runnable {
        private InboundMessageWorker() {
        }

        @Override
        public void run() {
            try {
                Message msg;
                while ((msg = ClientConnection.this.in.readMessage()) != null) {
                    FastMessageType responseMessageType = ClientConnection.this.getMessageType(msg);
                    ClientConnection.this.serviceMessageQueue.offer(new ServiceMessage(System.currentTimeMillis()));
                    switch (responseMessageType) {
                        case TEST_REQUEST: {
                            TestRequest testRequest = ServerResponseMessageParser.parseTestRequest(msg);
                            ClientConnection.this.sendHeartbeat(testRequest.getTestReqID());
                            break;
                        }
                        case HEARTBEAT: {
                            break;
                        }
                        case LOGON: {
                            ClientConnection.this.isLoggedOn = true;
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case LOGOUT: {
                            ClientConnection.this.isLoggedOn = false;
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                            break;
                        }
                        case REJECT: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg, true, false));
                            break;
                        }
                        default: {
                            ClientConnection.this.clientMessageQueue.offer(new ClientMessage(msg));
                        }
                    }
                    if (!ClientConnection.this.isMessageLoggingEnabled) continue;
                    System.out.println("Recieved message: " + msg.toString());
                }
            }
            catch (FastException e) {
                ClientConnection.this.isLoggedOn = false;
                ClientConnection.this.isConnected = false;
            }
        }
    }

    private class StreamWoker
    implements Runnable {
        private ArrayCache[] batchValues;
        private ArrayCache[] batchValuesTime;
        private int[] dimensions;
        private MetricUpdateCallback streamRefreshCallback = null;
        private SimpleMetricUpdateCallback streamRefreshCallbackPureData = null;

        public StreamWoker(ArrayCache[] batchValues, ArrayCache[] batchValuesTime, int[] dimensions, MetricUpdateCallback streamRefreshCallback, SimpleMetricUpdateCallback streamRefreshCallbackPureData) {
            this.batchValues = batchValues;
            this.batchValuesTime = batchValuesTime;
            this.dimensions = dimensions;
            this.streamRefreshCallback = streamRefreshCallback;
            this.streamRefreshCallbackPureData = streamRefreshCallbackPureData;
        }

        @Override
        public void run() {
            Console.writeln("Start stream data");
            ClientConnection.this.isStreamRuning.set(true);
            String stopReason = "terminated by user";
            while (ClientConnection.this.isStreamEnabled.get() && !Thread.interrupted()) {
                try {
                    Message responseMsg = ClientConnection.this.awaitResponse();
                    FastMessageType responseMessageType = ClientConnection.this.getMessageType(responseMsg);
                    if (responseMessageType == FastMessageType.LOGOUT) {
                        ClientConnection.this.clientMessageQueue.offer(new ClientMessage(responseMsg));
                        break;
                    }
                    TransmitDataRequest response = ServerResponseMessageParser.parseTransmitDataRequest(responseMsg);
                    if (response.getMsgType().contains("OK")) {
                        float[] data = response.getDataFloat();
                        long[] time = response.getTime();
                        if (data.length == 0) continue;
                        int k = 0;
                        while (k < this.batchValues.length) {
                            this.batchValuesTime[k].lockToWrite();
                            this.batchValues[k].lockToWrite();
                            ++k;
                        }
                        int len = 0;
                        int t = 0;
                        while (t < time.length) {
                            int k2 = 0;
                            while (k2 < this.dimensions.length) {
                                int m = 0;
                                while (m < this.dimensions[k2]) {
                                    this.batchValues[k2].writeNextDouble(data[len]);
                                    ++len;
                                    ++m;
                                }
                                this.batchValuesTime[k2].writeNextLong(time[t]);
                                ++k2;
                            }
                            ++t;
                        }
                        int k3 = 0;
                        while (k3 < this.batchValues.length) {
                            this.batchValuesTime[k3].unlockToWrite();
                            this.batchValues[k3].unlockToWrite();
                            ++k3;
                        }
                        if (this.streamRefreshCallback != null) {
                            ArrayList<MetricRefreshValue> refreshValue = new ArrayList<MetricRefreshValue>();
                            len = 0;
                            int i = 0;
                            while (i < time.length) {
                                int j = 0;
                                while (j < this.dimensions.length) {
                                    int k4 = 0;
                                    while (k4 < this.dimensions[j]) {
                                        if (!Double.isNaN(data[len]) && ClientConnection.this.batchMetricKeys != null) {
                                            refreshValue.add(new MetricRefreshValue((String)ClientConnection.this.batchMetricKeys.get(j), k4, data[len], time[i]));
                                        }
                                        ++len;
                                        ++k4;
                                    }
                                    ++j;
                                }
                                ++i;
                            }
                            if (refreshValue.size() > 0) {
                                this.streamRefreshCallback.onDataRefresh(refreshValue);
                            }
                        }
                        if (this.streamRefreshCallbackPureData != null && time.length > 0) {
                            this.streamRefreshCallbackPureData.onDataRefresh(data, time);
                        }
                        if (!response.getMsgType().contains("STOP")) continue;
                        stopReason = "terminated by server";
                        break;
                    }
                    stopReason = response.getMsgBody();
                }
                catch (IOException e) {
                    stopReason = "Error - " + e.getMessage();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    stopReason = "Error - " + e.getMessage();
                }
                break;
            }
            Console.writeln("Stop stream data: " + stopReason);
            ClientConnection.this.isStreamEnabled.set(false);
            ClientConnection.this.isStreamRuning.set(false);
        }
    }
}

