/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.operator;

import org.openfast.Global;
import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.error.FastConstants;
import org.openfast.template.Scalar;
import org.openfast.template.operator.AlwaysPresentOperatorCodec;
import org.openfast.template.operator.Operator;
import org.openfast.template.type.Type;

final class DeltaIntegerOperatorCodec
extends AlwaysPresentOperatorCodec {
    private static final long serialVersionUID = 1L;

    DeltaIntegerOperatorCodec(Operator operator, Type[] types) {
        super(operator, types);
    }

    public ScalarValue getValueToEncode(ScalarValue value, ScalarValue priorValue, Scalar field) {
        if (priorValue == null) {
            Global.handleError(FastConstants.D6_MNDTRY_FIELD_NOT_PRESENT, "The field " + field + " must have a priorValue defined.");
            return null;
        }
        if (value == null) {
            if (field.isOptional()) {
                return ScalarValue.NULL;
            }
            throw new IllegalArgumentException("Mandatory fields can't be null.");
        }
        if (priorValue.isUndefined()) {
            priorValue = field.getBaseValue();
        }
        return ((NumericValue)value).subtract((NumericValue)priorValue);
    }

    public ScalarValue decodeValue(ScalarValue newValue, ScalarValue previousValue, Scalar field) {
        if (previousValue == null) {
            Global.handleError(FastConstants.D6_MNDTRY_FIELD_NOT_PRESENT, "The field " + field + " must have a priorValue defined.");
            return null;
        }
        if (newValue == null || newValue.isNull()) {
            return null;
        }
        if (previousValue.isUndefined()) {
            previousValue = field.getDefaultValue().isUndefined() ? field.getBaseValue() : field.getDefaultValue();
        }
        return ((NumericValue)newValue).add((NumericValue)previousValue);
    }

    public ScalarValue decodeEmptyValue(ScalarValue previousValue, Scalar field) {
        if (previousValue.isUndefined()) {
            if (field.getDefaultValue().isUndefined()) {
                if (field.isOptional()) {
                    return ScalarValue.UNDEFINED;
                }
                Global.handleError(FastConstants.D5_NO_DEFAULT_VALUE, "");
            } else {
                return field.getDefaultValue();
            }
        }
        return previousValue;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

