% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scottish_postcode_lookup.R
\name{scottish_postcode_lookup}
\alias{scottish_postcode_lookup}
\title{Scottish postcode lookup}
\usage{
scottish_postcode_lookup(postcode)
}
\arguments{
\item{postcode}{A string. One valid Scottish postcode.
This function is case- and space-insensitive.
For non-Scottish postcodes use \code{\link{postcode_lookup}}.
For more than one non-Scottish postcode use \code{\link{bulk_postcode_lookup}}.}
}
\value{
A data frame. Returns all available data if found. Returns NAs if postcode does not exist (404).
\itemize{
\item \code{postcode} Postcode. Royal Mail postcode.
\item \code{scottish_parliamentary_constituency} Scottish Parliamentary
Constituency 2014 Scottish Parliamentary Constituency.
\item \code{scottish_parliamentary_constituency} Scottish Parliamentary
Constituency GSS Code. A code that identifies a 2014 Scottish
Parliamentary Constituency.
}

See
\url{https://postcodes.io/docs} for more details.
}
\description{
Lookup a Scottish postcode.
}
\examples{
\donttest{
scottish_postcode_lookup("EH12NG")
}
}
