% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTMulabAll.R
\name{PrInDTMulabAll}
\alias{PrInDTMulabAll}
\title{Multiple label classification based on all observations}
\usage{
PrInDTMulabAll(datain, classnames, ctestv=NA, conf.level=0.95, indind, indaddind,
       inddep)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classnames}{names of class variables (character vector)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1);\cr
default = 0.95}

\item{indind}{indices of independent variables}

\item{indaddind}{indices of additional predictors used in the case of dependent binary relevance modeling}

\item{inddep}{indices of dependent variables}
}
\value{
\describe{ 
\item{accabr}{model errors for Binary Relevance (single assessment) - only independent predictors are used for modeling one label at a time,  
the other labels are not used as predictors. The classification rules are trained on all observations. 
As the performance measure for the resulting classification rules, the balanced accuracy of the models for each individual label is employed.}
\item{errabin}{combined error for Binary Relevance (joint assessment) - the best prediction models for the different labels are combined to assess the 
combined prediction. The 01-accuracy counts a label combination as correct only if all labels are correctly predicted. 
The hamming accuracy corresponds to the proportion of labels whose value is correctly predicted.}
\item{accadbr}{model errors in Dependent Binary Relevance (Extended Model) (single assessment) - each label is trained by means of an extended model which 
not only includes the independent predictors but also the other labels. For these labels the truly observed values are used for estimation 
and prediction. In the extended model, further labels, which are not treated as dependent variables, can be used as additional predictors.}
\item{erraext}{combined errors for Dependent Binary Relevance (Extended Model) (joint assessment) }
\item{erratrue}{combined errors for Dependent Binary Relevance (True Prediction) - in the prediction phase, the values 
of all modeled labels are first predicted by the independent predictors only (see Binary Relevance) and then the predicted labels are used in  
the estimated extended model in a 2nd step to ultimately predict the labels.}
\item{coldata}{column names of input data}
\item{inddep}{indices of dependent variables (labels to be modeled)}
\item{treeabr}{list of trees from Binary Relevance modeling, one tree for each label; refer to an individual tree as \code{treeabr[[i]]}, 
                i = 1, ..., no. of labels}
\item{treeadbr}{list of trees from Dependent Binary Relevance modeling, one for each label; refer to an individual tree as \code{treeadbr[[i]]}, 
                i = 1, ..., no. of labels}
}
}
\description{
Multiple label classification based on all observations. We consider two ways of modeling (Binary relevance modeling, 
dependent binary modeling) and three ways of model evaluation: single 
assessment, joint assessment, and true prediction (see the Value section for more information).\cr
Interpretability is checked (see ctestv).\cr
Variables should be arranged in 'datain' according to indices specified in 'indind', 'indaddind', and 'inddep'.\cr

\strong{Reference}\cr Probst, P., Au, Q., Casalicchio, G., Stachl, C., and Bischl, B. 2017. Multilabel Classification with 
R Package mlr. arXiv:1703.08991v2
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)}  where 'name' is the output data 
frame of the function.\cr
The plot function will produce a series of more than one plot. If you use R, you might want to specify \code{windows(record=TRUE)} before 
\code{plot(name)} to save the whole series of plots. In R-Studio this functionality is provided automatically.
}
\examples{
data <- PrInDT::data_land # load data
dataclean <- data[,c(1:7,23:24,11:13,22,8:10)]  # only relevant features
indind <- c(1:9) # original predictors
indaddind <- c(10:13) # additional predictors
inddep <- c(14:16) # dependent variables
dataclean <- na.omit(dataclean)
ctestv <- NA
##
# Call PrInDTAll: language by language
##
outmultAll <- PrInDTMulabAll(dataclean,colnames(dataclean)[inddep],ctestv,conf.level=0.95,
                     indind,indaddind,inddep)
outmultAll
plot(outmultAll)

}
