% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrInDTMulev.R
\name{PrInDTMulev}
\alias{PrInDTMulev}
\title{PrInDT analysis for a classification problem with multiple classes.}
\usage{
PrInDTMulev(datain, classname, ctestv=NA, N, conf.level=0.95)
}
\arguments{
\item{datain}{Input data frame with class factor variable 'classname' and the\cr
influential variables, which need to be factors or numericals (transform logicals and character variables to factors)}

\item{classname}{Name of class variable (character)}

\item{ctestv}{Vector of character strings of forbidden split results;\cr
{see function \code{\link{PrInDT}} for details.}\cr
If no restrictions exist, the default = NA is used.}

\item{N}{Number of repetitions (integer > 0)}

\item{conf.level}{(1 - significance level) in function \code{ctree} (numerical, > 0 and <= 1)\cr
(default = 0.95)}
}
\value{
\describe{
\item{class}{levels of class variable} 
\item{trees}{trees for the levels of the class variable; refer to an individual tree as \code{trees[[k]]}, k = 1, ..., no. of levels}
\item{ba}{balanced accuracy of combined predictions} 
\item{conf}{confusion matrix of combined predictions} 
\item{ninterp}{no. of non-interpretable trees} 
}
}
\description{
PrInDT analysis for a classification problem with more than 2 classes. For each combination of one class vs. 
the other classes a 2-class \code{\link{PrInDT}} analysis is carried out.\cr
The percentages for undersampling of the larger class ('percl' in \code{\link{PrInDT}}) are chosen so that the resulting sizes
are comparable with the size of the smaller classes for which all their observations are used in undersampling ('percs' = 1 in \code{\link{PrInDT}}).\cr
The class with the highest probability in the K (= number of classes) analyses is chosen for prediction.\cr
Interpretability is checked (see 'ctestv').
}
\details{
Standard output can be produced by means of \code{print(name)} or just \code{ name } as well as \code{plot(name)}  where 'name' is the output data 
frame of the function.\cr
The plot function will produce a series of more than one plot. If you use R, you might want to specify \code{windows(record=TRUE)} before 
\code{plot(name)} to save the whole series of plots. In R-Studio this functionality is provided automatically.
}
\examples{
datastrat <- PrInDT::data_zero
data <- na.omit(datastrat)
ctestv <- NA
data$rel[data$ETH \%in\% c("C1a","C1b","C1c") & data$real == "zero"] <- "zero1"
data$rel[data$ETH \%in\% c("C2a","C2b","C2c") & data$real == "zero"] <- "zero2"
data$rel[data$real == "realized"] <- "real"
data$rel <- as.factor(data$rel) # rel is new class variable
data$real <- NULL # remove old class variable
N <- 51
conf.level <- 0.99 # 1 - significance level (mincriterion) in ctree
out <- PrInDTMulev(data,"rel",ctestv,N,conf.level) 
out # print best models based on subsamples
plot(out) # corresponding plots

}
