% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{create.ID.coords}
\alias{create.ID.coords}
\title{ID spatial coordinates}
\usage{
create.ID.coords(data, coords)
}
\arguments{
\item{data}{a data frame containing the spatial coordinates.}

\item{coords}{an object of class \code{\link{formula}} indicating the geographic coordinates.}
}
\value{
a vector of integers indicating the corresponding rows in \code{data} for each distinct coordinate obtained with the \code{\link{unique}} function.
}
\description{
Creates ID values for the unique set of coordinates.
}
\examples{
x1 <- runif(5)
x2 <- runif(5)
data <- data.frame(x1=rep(x1,each=3),x2=rep(x2,each=3))
ID.coords <- create.ID.coords(data,coords=~x1+x2)
data[,c("x1","x2")]==unique(data[,c("x1","x2")])[ID.coords,]

}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}

