% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{spatial.pred.poisson.MCML}
\alias{spatial.pred.poisson.MCML}
\title{Spatial predictions for the Poisson model with log link function, using plug-in of MCML estimates}
\usage{
spatial.pred.poisson.MCML(object, grid.pred, predictors = NULL, control.mcmc,
  type = "marginal", scale.predictions = c("log", "exponential"),
  quantiles = c(0.025, 0.975), standard.errors = FALSE, thresholds = NULL,
  scale.thresholds = NULL, plot.correlogram = FALSE, messages = TRUE)
}
\arguments{
\item{object}{an object of class "PrevMap" obtained as result of a call to \code{\link{poisson.log.MCML}}.}

\item{grid.pred}{a matrix of prediction locations.}

\item{predictors}{a data frame of the values of the explanatory variables at each of the locations in \code{grid.pred}; each column correspond to a variable and each row to a location. \bold{Warning:} the names of the columns in the data frame must match those in the data used to fit the model. Default is \code{predictors=NULL} for models with only an intercept.}

\item{control.mcmc}{output from \code{\link{control.mcmc.MCML}}.}

\item{type}{a character indicating the type of spatial predictions: \code{type="marginal"} for marginal predictions or \code{type="joint"} for joint predictions. Default is \code{type="marginal"}. In the case of a low-rank approximation only joint predictions are available.}

\item{scale.predictions}{a character vector of maximum length 2, indicating the required scale on which spatial prediction is carried out: "log" and "exponential". Default is \code{scale.predictions=c("log","exponential")}.}

\item{quantiles}{a vector of quantiles used to summarise the spatial predictions.}

\item{standard.errors}{logical; if \code{standard.errors=TRUE}, then standard errors for each \code{scale.predictions} are returned. Default is \code{standard.errors=FALSE}.}

\item{thresholds}{a vector of exceedance thresholds; default is \code{thresholds=NULL}.}

\item{scale.thresholds}{a character value indicating the scale on which exceedance thresholds are provided; \code{"log"} or \code{"exponential"}. Default is \code{scale.thresholds=NULL}.}

\item{plot.correlogram}{logical; if \code{plot.correlogram=TRUE} the autocorrelation plot of the conditional simulations is displayed.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}
}
\value{
A "pred.PrevMap" object list with the following components: \code{log}; \code{exponential}; \code{exceedance.prob}, corresponding to a matrix of the exceedance probabilities where each column corresponds to a specified value in \code{thresholds}; \code{samples}, corresponding to a matrix of the predictive samples at each prediction locations for the linear predictor of the Poisson model (if \code{scale.predictions="log"} this component is \code{NULL}); \code{grid.pred} prediction locations.
Each of the three components \code{log} and  \code{exponential} is also a list with the following components:

\code{predictions}: a vector of the predictive mean for the associated quantity (log or exponential).

\code{standard.errors}: a vector of prediction standard errors (if \code{standard.errors=TRUE}).

\code{quantiles}: a matrix of quantiles of the resulting predictions with each column corresponding to a quantile specified through the argument \code{quantiles}.
}
\description{
This function performs spatial prediction, fixing the model parameters at the Monte Carlo maximum likelihood estimates of a geostatistical Poisson model with log link function.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
