% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{spat.corr.diagnostic}
\alias{spat.corr.diagnostic}
\title{Diagnostics for residual spatial correlation}
\usage{
spat.corr.diagnostic(
  formula,
  units.m = NULL,
  coords,
  data,
  likelihood,
  ID.coords = NULL,
  n.sim = 200,
  nAGQ = 1,
  uvec = NULL,
  plot.results = TRUE,
  lse.variogram = FALSE,
  kappa = 0.5,
  which.test = "both"
)
}
\arguments{
\item{formula}{an object of class \code{\link{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{units.m}{vector of binomial denominators, or offset if the Poisson model is used.}

\item{coords}{an object of class \code{\link{formula}} indicating the geographic coordinates.}

\item{data}{an object of class "data.frame" containing the data.}

\item{likelihood}{a character that can be set to "Gaussian","Binomial" or "Poisson"}

\item{ID.coords}{vector of ID values for the unique set of spatial coordinates obtained from \code{\link{create.ID.coords}}.
These must be provided if, for example, spatial random effects are defined at
 household level but some of the covariates are at individual level. \bold{Warning}: the household coordinates must all be distinct
 otherwise see \code{jitterDupCoords}. Default is \code{NULL}.}

\item{n.sim}{number of simulations used to perform the selected test(s) for spatial correlation.}

\item{nAGQ}{integer scalar (passed to \code{\link{glmer}}) - the number of points per axis for evaluating the adaptive Gauss-Hermite approximation to the log-likelihood.
Defaults to 1, corresponding to the Laplace approximation. Values greater than 1 produce greater accuracy in the evaluation of the
 log-likelihood at the expense of speed. A value of zero uses a faster but less exact form of parameter estimation for GLMMs by optimizing
  the random effects and the fixed-effects coefficients in the penalized iteratively reweighted least squares step.}

\item{uvec}{a vector with values used to define the variogram binning. If \code{uvec=NULL}, then \code{uvec} is then set to \code{seq(MIN_DIST,(MAX_DIST-MIN_DIST)/2,length=15)}
where \code{MIN_DIST} and \code{MAX_DIST} are the minimum and maximum observed distances.}

\item{plot.results}{if \code{plot.results=TRUE}, a plot is returned showing the results for the selected test(s) for spatial correlation. By default \code{plot.results=TRUE}.}

\item{lse.variogram}{if \code{lse.variogram=TRUE}, a weighted least square fit of a Matern function (with fixed \code{kappa}) to the empirical variogram is performed. If \code{plot.results=TRUE} and \code{lse.variogram=TRUE}, the
fitted weighted least square fit is displayed as a dashed line in the returned plot.}

\item{kappa}{smothness parameter of the Matern function for the Gaussian process to approximate. The deafault is \code{kappa=0.5}.}

\item{which.test}{a character specifying which test for residual spatial correlation is to be performed: "variogram", "test statistic" or "both". The default is \code{which.test="both"}. See 'Details'.}
}
\value{
An object of class "PrevMap.diagnostic" which is a list containing the following components:

\code{obs.variogram}: a vector of length \code{length(uvec)-1} containing the values of the variogram for each of
the distance bins defined through \code{uvec}.

\code{distance.bins}: a vector of length \code{length(uvec)-1} containing the average distance within each of the distance bins
defined through \code{uvec}.

\code{n.bins}: a vector of length \code{length(uvec)-1} containing the number of pairs of data-points falling within each distance bin.

\code{lower.lim}: (available only if \code{which.test="both"} or \code{which.test="variogram"}) a vector of length \code{length(uvec)-1} containing the lower limits of the 95% confidence interval for the empirical variogram
generated under the assumption of absence of spatial correlation at each fo the distance bins  defined through \code{uvec}.

\code{upper.lim}: (available only if \code{which.test="both"} or \code{which.test="variogram"}) a vector of length \code{length(uvec)-1} containing the upper limits of the 95% confidence interval for the empirical variogram
generated under the assumption of absence of spatial correlation at each fo the distance bins  defined through \code{uvec}.

\code{mode.rand.effects}: the predictive mode of the random effects from the fitted non-spatial generalized linear mixed model.

\code{p.value}: (available only if \code{which.test="both"} or \code{which.test="test statistic"}) p-value of the test for residual spatial correlation.

\code{lse.variogram}: (available only if \code{lse.variogram=TRUE}) a vector of length \code{length(uvec)-1} containing the values of the estimated Matern variogram via a weighted least square fit.
}
\description{
This function performs two variogram-based tests for residual spatial correlation in real-valued and count (Binomial and Poisson) data.
}
\details{
The function first fits a generalized linear mixed model using the for an outcome \eqn{Y_i} which, conditionally on i.i.d. random effects \eqn{Z_i}, are mutually independent
GLMs with linear predictor
\deqn{g^{-1}(\eta_i)=d_i'\beta+Z_i}
where \eqn{d_i} is a vector of covariates which are specified through \code{formula}. Finally, the \eqn{Z_i} are assumed to be zero-mean Gaussian variables with variance \eqn{\sigma^2}

\bold{Variogram-based graphical diagnostic}

This graphical diagnostic is performed by setting \code{which.test="both"} or \code{which.test="variogram"}. The output are 95% confidence intervals
(see below \code{lower.lim} and \code{upper.lim}) that are generated under the assumption of spatial indepdence through the following steps

1. Fit a generalized linear mixed model as indicated by the equation above.

2. Obtain the mode, say \eqn{\hat{Z}_i}, of the \eqn{Z_i} conditioned on the data \eqn{Y_i}.

3. Compute the empirical variogram using \eqn{\hat{Z}_i}

4. Permute the locations specified in \code{coords}, \code{n.sim} time while holding the \eqn{\hat{Z}_i} fixed.

5. For each of the permuted data-sets compute the empirical variogram based on the \eqn{\hat{Z}_i}.

6. From the \code{n.sim} variograms obtained in the previous step, compute the 95% confidence interval.

If the observed variogram (\code{obs.variogram} below), based on the un-permuted \eqn{\hat{Z}_i}, falls within the 95% confidence interval, we interpret this as evidence that the data do not show
residual spatial correlation; if, instead, that partly falls outside the 95% confidence intervals, we interpret this as evidence of residual spatial correlation.

\bold{Test for spatial independence}

This diagnostic test is performed if \code{which.test="both"} or \code{which.test="test statistic"}. Let \eqn{\hat{v}(B)} denote the empirical variogram based on \eqn{\hat{Z}_i} for the distance bin \eqn{B}.
The test statistic used for testing residual spatial correlation is
\deqn{T = \sum_{B} N(B) \{v(B)-\hat{\sigma}^2\}}
where \eqn{N(B)} is the number of pairs of data-points falling within the distance bin \eqn{B} (\code{n.bins} below) and \eqn{\hat{\sigma}^2} is the estimate of \eqn{\sigma^2}.

To obtain the distribution of the test statistic \eqn{T} under the null hypothesis of spatial independence, we use the simulated empirical variograms as obtained in step 5 of the iterative procedure described in "Variogram-based graphical diagnostic."
The p-value for the test of spatial independence is then computed by taking the proportion of simulated values for \eqn{T} under the null the hypothesis that are larger than the value of \eqn{T} based on the original (un-permuted) \eqn{\hat{Z}_i}
}
