% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/construction.R
\name{construct_nlocal}
\alias{construct_nlocal}
\title{Non-local network construction}
\usage{
construct_nlocal(input, db = c("Biogrid", "HPRD"), species = c("human",
  "ath"), ID.type = c("Gene symbol", "Entrez Gene"),
  hierarchy = 1)
}
\arguments{
\item{input}{A data frame containing the experimental data.}

\item{db}{Integrated PPI database, either \code{Biogrid} or \code{\link{HPRD}}.}

\item{species}{This parameter indicates the biological species to which analyzable PPI data is related; currently \code{human} for "Homo sapiens" and \code{ath} for "Arabidopsis thaliana" are available.}

\item{ID.type}{The ID type of the biological genes or proteins, possible values are \code{Entrez gene} and \code{Gene symbol} when \code{db} is \code{Biogrid}, or \code{Gene symbol} when \code{db} is \code{\link{HPRD}}.}

\item{hierarchy}{This parameter indicates how many hierarchy are included in the network, currently it can be \code{0}, \code{1} or \code{2}. Default value is \code{1}.}
}
\value{
A network in igraph format.
}
\description{
Construction a network from integrated PPI database.
}
\examples{
nlocal<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construct_nlocal(input=nlocal,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
}
\seealso{
\code{\link{construction}}, \code{\link{construct_local}}.
}

