% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/09playing_routines.r
\docType{methods}
\name{playWave}
\alias{playWave}
\alias{playWave,Wave-method}
\title{Play Wave objects}
\usage{
\S4method{playWave}{Wave}(wave, wait = T)
}
\arguments{
\item{wave}{An object of class \code{\link[tuneR]{Wave}}.}

\item{wait}{A logical value. When set to \code{TRUE} the playing
routine will wait with executing any code until the playing is
finished. When set to \code{FALSE}, subsequent R code will be
executed while playing.}
}
\value{
Returns nothing (\code{NULL}).
}
\description{
Use the command line \code{\link[audio]{play}} function from the
\code{audio} package to play \code{\link[tuneR]{Wave}} objects.
}
\details{
As the \code{\link{tuneR}} package play-function relies on external
players, this method is provided as a convenient approach to play
samples in the R console, using the \code{audio} package. Wave
objects are played at the rate as specified in the object.
}
\examples{
\dontrun{
data(mod.intro)

## PTSample objects can also be
## played with this function as they
## are a child of the Wave object:
playWave(PTSample(mod.intro, 2))
}
}
\author{
Pepijn de Vries
}
\seealso{
Other play.audio.routines: \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playSample}},
  \code{\link{playSample,PTModule-method}},
  \code{\link{playSample,PTSample-method}}
}

