% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{moduleSize}
\alias{moduleSize}
\alias{moduleSize,PTModule-method}
\title{Get module file size}
\usage{
\S4method{moduleSize}{PTModule}(x)
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the file size is
to be calculated.}
}
\value{
Returns potential uncompressed module file size in bytes represented
by a number of class \code{object_size}.
}
\description{
Get the file size in bytes of a \code{\link{PTModule}} object, when it is to be saved
as an original module file with \code{\link{write.module}}.
}
\details{
The ProTracker module has a 1084 byte sized header containing all (meta)
information on the patterns, their order and the audio samples. Each pattern
holds exactly 1 Kb of information and the length of the audio samples corresponds
with the size in bytes, as they are of 8 bit quality in mono. This function
calculates the file size of the \code{\link{PTModule}} object when it is to
be saved with \code{\link{write.module}}.
}
\examples{
## Calculate the file size for the example module 'mod.intro':

data("mod.intro")
moduleSize(mod.intro)

## Note that this is not the same as the size the object
## requires in R working memory:

object.size(mod.intro)

## In working memory it takes more memory to store the module, than in a
## file. This is because the S4 structure of the object consumes some
## memory. In addition, samples are of 8 bit quality, corresponding with
## a byte per sample. In the PTSample object it is stored as a
## vector of integer values. In R, integer values are 32 bit, which
## costs 4 times as much memory as the original 8 bit.

}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{fix.PTModule}}, \code{\link{modToWave}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}
}

