% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08coercion.r
\docType{methods}
\name{PTSample-method}
\alias{PTSample-method}
\alias{PTSample,Wave,missing-method}
\alias{PTSample,raw,missing-method}
\alias{PTSample,PTModule,numeric-method}
\alias{PTSample<-}
\alias{PTSample<-,PTModule,numeric,PTSample-method}
\title{Coerce to or replace PTSample}
\usage{
\S4method{PTSample}{Wave,missing}(x)

\S4method{PTSample}{raw,missing}(x)

\S4method{PTSample}{PTModule,numeric}(x, index)

\S4method{PTSample}{PTModule,numeric,PTSample}(x, index) <- value
}
\arguments{
\item{x}{Object (any of class \code{\link[tuneR]{Wave}}, a \code{vector}
of \code{raw} data, or of class \code{\link{PTModule}}) that needs to
be coerced to a \code{\link{PTSample}} object. In the latter case, the
object can also be replaced.}

\item{index}{A positive \code{integer} index of the sample in \code{\link{PTModule}}
\code{x} that needs to be returned or replaced.}

\item{value}{An object of \code{\link{PTSample}} with which the \code{\link{PTSample}}
object at the specified \code{index} in object \code{x} needs to be replaced.}
}
\value{
When \code{PTSample} is used, a \code{PTSample} object
based on \code{x} is returned.

When \code{PTSample<-} is used, object \code{x} is returned in which
the selected \code{PTSample} is replaced with \code{value}.
}
\description{
This method will coerce a set of objects to a \code{PTSample} object. It can also
be used to select specific samples from \code{PTModule} objects and replace
the selected \code{PTSample}.
}
\details{
Method to coerce \code{x} to class \code{\link{PTSample}}.

When \code{x} is a \code{\link[tuneR]{Wave}} object, this method will not
resample it. However, the sample rate will be adjusted and samples exeeding
the maximum length of \code{2*0xffff} = \code{131070} will be clipped to this
maximum length. When \code{x} is a stereo sample, it will be converted to
mono, by averaging the left and right channel.

When \code{x} is a \code{vector} of \code{raw} data, it will be truncated
if the maximum length of \code{2*0xffff} = \code{131070} is exceeded.
The raw will be converted with \code{\link{rawToSignedInt}} in order
to represent an 8 bit mono \code{\link{waveform}}.

As samples must have an even length (as per ProTracker specifications),
a 0x00 value is appended if the length is odd.

When \code{x} is of class \code{\link{PTModule}}, the \code{PTSample} at the
specified \code{index} is returned, or will be replaced.
}
\examples{
## Create a raw data sine wave:
raw_sine <- signedIntToRaw(round(sin(2*pi*(0:275)/276)*127))

data("mod.intro")

## Replace sample number 1 from mod.intro
## with the sine wave:
PTSample(mod.intro, 1) <-
  PTSample(raw_sine)

## Note that the replacement above
## could also (maybe more efficiently)
## be done with the 'waveform' method

## Restore the loop in sample number 1:
loopLength(PTSample(mod.intro, 1)) <- 276

}
\seealso{
Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{fineTune}}, \code{\link{loopLength}},
  \code{\link{loopSample}}, \code{\link{loopStart}},
  \code{\link{loopState}}, \code{\link{name}},
  \code{\link{playSample}}, \code{\link{read.sample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}
}
\author{
Pepijn de Vries
}
