% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{fix.PTModule}
\alias{fix.PTModule}
\alias{fix.PTModule,PTModule,logical-method}
\alias{fix.PTModule,PTModule,missing-method}
\title{Attempt to fix PTModule to ProTracker specs}
\usage{
\S4method{fix.PTModule}{PTModule,logical}(mod, verbose = T)

\S4method{fix.PTModule}{PTModule,missing}(mod)
}
\arguments{
\item{mod}{A \code{\link{PTModule}} object which needs fixing.}

\item{verbose}{With the default value of \code{TRUE}, the method
prints a progress report to the \code{\link{sink}}. When set
to \code{FALSE}, the progress report is suppressed.}
}
\value{
Returns a copy of object \code{mod} in which all non-conformaties are
attempted to be fixed. (Attempted) fixes are listed printed
in the progress report.
}
\description{
Try to fix non-valid \code{\link{PTModule}} objects in order to meet with
ProTracker specs such that they pass validity tests.
}
\details{
Almost any file can be read as a \code{\link{PTModule}} object (using
\code{\link{read.module}}) when validity is ignored and no unexpected end
of file is reached. This package's object validity are very strickly testing
for compliance with ProTracker specifications. As many modules could have
been created with other trackers (which often will play just as well in
ProTracker) it is desirable to convert such object to ProTracker specs.
This method attempts to do so, by fixing each aspect, that is also tested
in the object validity functions. Note that the attempts are no guarantee for success,
and `fixed' modules may not play as intended.
}
\note{
In the current version, pattern data itself is not checked for
non-conformaties nor is it fixed.
}
\examples{
\dontrun{
data("mod.intro")

## Let's do something illegal and destroy mod.intro:
mod.intro@pattern.order <- mod.intro@pattern.order[1:9]

## We should have used the 'patternOrder'-method to
## change the pattern order. Now we have broken the
## object:
validObject(mod.intro, TRUE)

## No worries, we can fix it:
mod.intro <- fix.PTModule(mod.intro)

## See, it's all OK again:
validObject(mod.intro, TRUE)
}
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{modToWave}}, \code{\link{moduleSize}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{rawToPTModule}},
  \code{\link{read.module}}, \code{\link{trackerFlag}},
  \code{\link{write.module}}
}
\author{
Pepijn de Vries
}
