% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11MODPlugHelpers.r
\name{PTPatternToMODPlug}
\alias{PTPatternToMODPlug}
\title{Convert PTPattern data into a MODPlug pattern}
\usage{
PTPatternToMODPlug(x, to.clipboard = T)
}
\arguments{
\item{x}{Either a \code{\link{PTPattern}} object or a
\code{\link{PTBlock}} object from which an Open
MODPlug Tracker pattern should be created.}

\item{to.clipboard}{A \code{logical} value, indicating whether the
result should be copied to the system's clipboard (\code{TRUE}) or
should be returned as a \code{vector} of \code{character}s
(\code{FALSE}).}
}
\value{
Returns an invisible \code{NULL} when
argument \code{to.clipboard} is set to \code{TRUE}.
Returns an Open MODPlug Tracker flavoured pattern table as
a \code{vector} of \code{character}s when it is set to \code{FALSE}.
}
\description{
Use a \code{\link{PTPattern}} or \code{\link{PTBlock}} to create
a pattern table with a MODPlug flavour.
}
\details{
The Open MODPlug Tracker (\url{https://www.openmpt.org}) is a modern
music tracker that is for free. It too can handle ProTracker modules.
This function assists in moving pattern data from R to Open MPT.
}
\examples{
\dontrun{
## get some pattern data

pattern <- PTPattern(mod.intro, 1)

## Now create a MODPlug pattern from this.
## The result is placed on the system clipboard.
## You can check by pasting it into a text
## editor, or better yet, the MODPlug Tracker.

PTPatternToMODPlug(pattern)

## If you want to handle the pattern data
## in R:

patModPlug <- PTPatternToMODPlug(pattern, F)

## We can do the same with a block:

block <- PTBlock(pattern, 1:10, 2:3)
PTPatternToMODPlug(block)
}
}
\seealso{
Other MODPlug.operations: 
\code{\link{MODPlugToPTPattern}()}

Other pattern.operations: 
\code{\link{MODPlugToPTPattern}()},
\code{\link{PTPattern-class}},
\code{\link{PTPattern-method}},
\code{\link{appendPattern}()},
\code{\link{deletePattern}()},
\code{\link{pasteBlock}()},
\code{\link{patternLength}()},
\code{\link{patternOrderLength}()},
\code{\link{patternOrder}()}
}
\author{
Pepijn de Vries
}
\concept{MODPlug.operations}
\concept{pattern.operations}
