% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extr_outs.R
\name{plot.extr}
\alias{plot.extr}
\title{Plots for the \code{extr} object}
\usage{
\method{plot}{extr}(x, ..., category = "ppdensity")
}
\arguments{
\item{x}{An object of class \code{extr}.}

\item{...}{Passed to \link[ggplot2:geom_histogram]{ggplot2::geom_histogram}, when \code{category = histogram}. Useful to change the
number of bins.}

\item{category}{A string indicating which plot to build. See options in the Details section.}
}
\description{
Build plots using the outputs stored in the \code{extr} object.
}
\details{
The available options are:
\itemize{
\item \code{ppdensity} : Density plots of the empirical and sampled data, useful to assess the
model's convergence.
\item \code{density} : Density plots of the model's effects.
\item \code{histogram} : Histograms of the model's effects.
\item \code{traceplot}: Trace plot showing the changes in the effects' values across iterations and chains.
}
}
\examples{
\donttest{
mod = bayes_met(data = maize,
                gen = "Hybrid",
                loc = "Location",
                repl = c("Rep","Block"),
                trait = "GY",
                reg = "Region",
                year = NULL,
                res.het = TRUE,
                iter = 2000, cores = 2, chain = 4)

outs = extr_outs(model = mod,
                 probs = c(0.05, 0.95),
                 verbose = TRUE)
plot(outs, category = "ppdensity")
plot(outs, category = "density")
plot(outs, category = "histogram")
plot(outs, category = "traceplot")
}

}
\seealso{
\link{extr_outs}
}
