% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreopt_functions.R
\name{checkinputs}
\alias{checkinputs}
\title{Check inputs to function.}
\usage{
checkinputs(data, prob, S, G, score = list(score = "energy", alpha = 1))
}
\arguments{
\item{data}{Past data realisations as vectors in a list.  Each list element corresponds to a period of training data.}

\item{prob}{List of functions to simulate from probabilistic forecasts.  Each list element corresponds to a period of training data. The output of each function should be a matrix.}

\item{S}{Matrix encoding linear constraints.}

\item{G}{Values of reconciliation parameters \eqn{d} and \eqn{G} where \eqn{\tilde{y}=S(d+G\hat{y})}.  The first \eqn{m} elements correspond to translation vector \eqn{d}, while the remaining elements correspond to the matrix \eqn{G} where the elements are filled in column-major order.}

\item{score}{Score to be used.  This must be a list with two elements: score for the scoring rule (currently only energy supported) and alpha, an additional parameter used in the score (e.g. power in energy score, default is 1).}
}
\description{
This function checks that the inputs for \code{\link[ProbReco]{scoreopt}} and \code{\link[ProbReco]{total_score}} are correctly setup.  It is called at the start of \code{\link[ProbReco]{scoreopt}}.
}
