save.project <- function(cache_dir="cache"){
  # saves all the variables in the workplace with a .out postfix
  vars = ls()
  indices = grep("\\.out$", vars) 
  for (index in indices){
    save(
      list=c(vars[index]), 
      file=paste(cache_dir, vars[index], sep="/")
    )  
  }    
}

stub.tests <- function(root_dir,tests_dir){
  # create a stub for every function we can find in the root directory
  env <- attach(NULL, name = "project")
  for (file in list.files(root_dir, pattern="\\.[rR]$")){
    sys.source(file, env)
  }
  for (var in ls(env)){
    if (is.function(env[[var]])){
      filename = paste('test_', var, '.r', sep="")
      code = cat(
        "test_that('",
        var,
        " does what it's supposed to')",
        "{\n expect_that(TRUE, is_false,\n\t info='you should write this test')\n})",
        sep="",
        file=paste(tests_dir,filename,sep='/')
      )
    }
  }
}
